/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.distribution.mediaroom;

import com.ericsson.cms.sites.monitoring.common.IAssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IStatusListener;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryResult;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DistributionStatusQueryThread
implements IStatusQueryThread {
    Date lastUpdate = null;
    Set<String> externalIds = Collections.synchronizedSet(new HashSet());
    IStatusQueryServiceFacade queryService = null;
    IStatusListener listener = null;
    private List<IAssetStatusBean> statusChangesList = Collections.synchronizedList(new ArrayList());
    private String id = null;
    private static final Logger logger = Logger.getLogger((String)DistributionStatusQueryThread.class.getName());

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public IStatusListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(IStatusListener listener) {
        this.listener = listener;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public Set<String> getExternalIds() {
        return this.externalIds;
    }

    @Override
    public void setExternalIds(Set<String> externalIds) {
        this.externalIds = externalIds;
    }

    @Override
    public IStatusQueryServiceFacade getQueryService() {
        return this.queryService;
    }

    @Override
    public void setQueryService(IStatusQueryServiceFacade queryService) {
        this.queryService = queryService;
    }

    @Override
    public void execute() {
        this.listener.callStarted(this);
        if (this.externalIds.size() == 0) {
            logger.debug((Object)String.format("No external Ids. Existing run() for thread id: %s without making weservice call.%n", this.id));
            return;
        }
        try {
            this.fetchAndReportResults();
            this.lastUpdate = new Date();
            this.listener.callCompleted(this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void fetchAndReportResults() throws Exception {
        long pageIndex = 0L;
        do {
            long nextIndex;
            this.statusChangesList.clear();
            IStatusQueryResult result = this.queryService.getAssetStatus(pageIndex);
            pageIndex = nextIndex = result.getNextPage();
            List<? extends IAssetStatusBean> assetStatusList = result.getAssets();
            if (assetStatusList == null || assetStatusList.size() == 0) break;
            for (IAssetStatusBean iAssetStatusBean : assetStatusList) {
                GregorianCalendar gmtModifiedDateTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                gmtModifiedDateTime.setTimeInMillis(iAssetStatusBean.getTimestamp());
                if (!gmtModifiedDateTime.getTime().after(this.lastUpdate)) continue;
                this.statusChangesList.add(iAssetStatusBean);
            }
            if (this.listener == null || this.statusChangesList.size() <= 0) continue;
            this.listener.statusChanged(this, this.statusChangesList);
        } while (pageIndex != -1L);
    }
}

