/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.distribution.mediaroom;

import com.ericsson.cms.sites.monitoring.common.SingleTaskTimer;
import com.ericsson.cms.sites.monitoring.config.ConfigurationManager;
import com.ericsson.cms.sites.monitoring.config.IStatusPluginConfiguration;
import com.ericsson.cms.sites.monitoring.distribution.DistributionStatusPluginBase;
import com.ericsson.cms.sites.monitoring.distribution.mediaroom.AxisStatusQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.distribution.mediaroom.DistributionStatusQueryThread;
import com.ericsson.cms.sites.monitoring.distribution.mediaroom.MediaRoomConfigurationParser;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.registry.PluginDescriptor;

public class MediaRoomStatusPlugin
extends DistributionStatusPluginBase {
    private static final Logger logger = Logger.getLogger((String)MediaRoomStatusPlugin.class.getName());

    @Override
    protected Map<String, Map<String, String>> translateConfig(Map<String, IStatusPluginConfiguration> sourceMap) {
        HashMap<String, Map<String, String>> translatedMap = new HashMap<String, Map<String, String>>();
        for (String key : sourceMap.keySet()) {
            IStatusPluginConfiguration config = sourceMap.get(key);
            HashMap<String, String> configProperties = new HashMap<String, String>();
            configProperties.put("Display Name", config.getConfigurationDisplayName());
            configProperties.put("Configuration ID", config.getConfigurationId());
            configProperties.put("Endpoint URL", config.getEndpointUrl());
            configProperties.put("Polling Interval", Long.toString(config.getPollInterval()));
            translatedMap.put(config.getConfigurationId(), configProperties);
        }
        return translatedMap;
    }

    @Override
    protected synchronized void _start() {
        try {
            logger.info((Object)"In MediaRoomStatusPlugin._start()...");
            if (this.started) {
                logger.warn((Object)"In MediaRoomStatusPlugin Already started");
                return;
            }
            this.multiConfiguration.clear();
            this.timerMap.clear();
            ClassLoader loader = this.getClass().getClassLoader();
            PluginDescriptor desc = this.getDescriptor();
            this.locateHomeDirectories(loader, desc);
            if (!this.tempDirectory.exists()) {
                this.tempDirectory.mkdir();
            }
            this.configurationManager = new ConfigurationManager();
            this.configParser = new MediaRoomConfigurationParser();
            this.configMap = this.configurationManager.configure(this.configDirectory, this.configParser);
            this.multiConfiguration = this.translateConfig(this.configMap);
            this.startTimers(this.configMap);
        }
        catch (Exception ex) {
            logger.error((Object)"Error Starting new configuration threads", (Throwable)ex);
            this.stopAllTimers();
            this.started = false;
            return;
        }
        this.started = true;
    }

    @Override
    protected synchronized void startTimers(Map<String, IStatusPluginConfiguration> selectedConfigMap) {
        for (String key : selectedConfigMap.keySet()) {
            IStatusPluginConfiguration config = selectedConfigMap.get(key);
            DistributionStatusQueryThread thread = new DistributionStatusQueryThread();
            thread.setId(key);
            Date dateFromFile = this.getLastUpdateDate(key);
            if (dateFromFile != null) {
                thread.setLastUpdate(dateFromFile);
            } else {
                thread.setLastUpdate(this.lastAppStartTime);
            }
            String targetEndpoint = config.getEndpointUrl();
            String filterStatus = "AutoImportAll";
            boolean filterByStatus = false;
            boolean includeExpiredAssets = false;
            AxisStatusQueryServiceFacade queryService = new AxisStatusQueryServiceFacade(includeExpiredAssets, filterByStatus, filterStatus, targetEndpoint);
            thread.setListener(this);
            thread.setQueryService(queryService);
            SingleTaskTimer<DistributionStatusQueryThread> timer = new SingleTaskTimer<DistributionStatusQueryThread>(config.getPollInterval(), thread);
            timer.start();
            this.timerMap.put(key, timer);
            logger.info((Object)String.format("Started Thread: %s for configuration ID: %s%n", thread.getId(), key));
        }
    }
}

