/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.normalization;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.custom.normalization.Util;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AttCopyPackageAssetId
implements CustomNormalizationRule {
    private static final String PACKAGE = "PACKAGE";
    private static final String TITLE = "TITLE";
    private static final String SRC_PACKAGE_ASSET_ID_XPATH = "/tns:Fields/tns:Identifier/tns:Id";
    private static final String DEST_PROGRAM_ID_XPATH = "/tns:Fields/tns:TvId/tns:ProgramId";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        RuleResults result = new RuleResults(title);
        List packageAssetId = title.getAsset().getAllFieldsForXpath(PACKAGE, SRC_PACKAGE_ASSET_ID_XPATH);
        List programId = title.getAsset().getAllFieldsForXpath(TITLE, DEST_PROGRAM_ID_XPATH);
        if (packageAssetId.size() == 0) {
            return result;
        }
        String packageAssetIdValue = ((Field)packageAssetId.get(0)).getValue();
        if (programId.size() == 1) {
            ((Field)programId.get(0)).setValue(packageAssetIdValue);
        } else {
            Field destNetworkField = new Field(DEST_PROGRAM_ID_XPATH, packageAssetIdValue);
            Util.setFieldIndices(destNetworkField);
            List titles = title.getAsset().getAllAssetsOfType(TITLE);
            ((Asset)titles.get(0)).addField(destNetworkField);
        }
        result.setModified(true);
        return result;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("AttCopyPackageAssetIdToProgramId", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

