/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.normalization;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AttRatingSystem
implements CustomNormalizationRule {
    private static final String TITLE = "TITLE";
    private static final String MOVIE = "MOVIE";
    private static final String RATING_VALUE_XPATH = "/tns:Fields/tns:Rating/tns:Value";
    private static final String RATING_SYSTEM_XPATH = "/tns:Fields/tns:Rating/tns:Value/@system";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        RuleResults result = new RuleResults(title);
        this.changeRating(title, TITLE);
        this.changeRating(title, MOVIE);
        return result;
    }

    private void changeRating(Title title, String assetType) {
        List ratingValueFields = title.getAsset().getAllFieldsForXpath(assetType, RATING_VALUE_XPATH);
        Map<List<Integer>, List<Field>> groupedFields = this.groupByIndices(ratingValueFields);
        for (List<Field> rating : groupedFields.values()) {
            Field ratingValue = null;
            Field ratingSystem = null;
            if (rating.get(0).getTtvXPath().equals(RATING_VALUE_XPATH)) {
                ratingValue = rating.get(0);
                if (rating.size() == 2) {
                    ratingSystem = rating.get(1);
                }
            } else {
                if (rating.size() == 2) {
                    ratingValue = rating.get(1);
                }
                ratingSystem = rating.get(0);
            }
            if (ratingSystem != null && !ratingSystem.getValue().trim().isEmpty() && ratingSystem.getValue().trim().equals("TV")) {
                ratingSystem.setValue("VCHIP");
                ratingValue.setValue("TV-".concat(ratingValue.getValue()));
            }
            if (ratingValue != null && !ratingValue.getValue().trim().isEmpty()) {
                if (ratingValue.getValue().trim().contains("NONE")) {
                    ratingValue.setValue("");
                    if (ratingSystem != null) {
                        ratingSystem.setValue("");
                    }
                } else if (ratingValue.getValue().trim().equals("NR")) {
                    if (ratingSystem != null) {
                        ratingSystem.setValue("NR");
                    } else {
                        this.addRatingSystemField(ratingValue.getParentAsset(), "NR", ratingValue.getIndices());
                    }
                } else if (ratingValue.getValue().trim().equals("AO")) {
                    if (ratingSystem != null) {
                        ratingSystem.setValue("AdultOnly");
                    } else {
                        this.addRatingSystemField(ratingValue.getParentAsset(), "AdultOnly", ratingValue.getIndices());
                    }
                } else if (ratingValue.getValue().trim().contains("TV-")) {
                    if (ratingSystem != null) {
                        ratingSystem.setValue("VCHIP");
                    } else {
                        this.addRatingSystemField(ratingValue.getParentAsset(), "VCHIP", ratingValue.getIndices());
                    }
                } else if (this.isMPAARating(ratingValue.getValue().trim())) {
                    if (ratingSystem != null) {
                        ratingSystem.setValue("MPAA");
                    } else {
                        this.addRatingSystemField(ratingValue.getParentAsset(), "MPAA", ratingValue.getIndices());
                    }
                }
            }
            if (ratingSystem == null || ratingSystem.getValue() == null || ratingSystem.getValue().trim().isEmpty() || ratingValue != null) continue;
            ratingSystem.setValue("");
        }
    }

    private boolean isMPAARating(String ratingValue) {
        return ratingValue.equals("G") || ratingValue.equals("PG") || ratingValue.equals("PG-13") || ratingValue.equals("R") || ratingValue.equals("NC-17");
    }

    private Map<List<Integer>, List<Field>> groupByIndices(List<Field> ratingValueFields) {
        HashMap<List<Integer>, List<Field>> groupedFields = new HashMap<List<Integer>, List<Field>>();
        for (Field f : ratingValueFields) {
            List<Field> fields;
            if (groupedFields.containsKey(f.getIndices())) {
                fields = (List)groupedFields.get(f.getIndices());
                fields.add(f);
                groupedFields.put(f.getIndices(), fields);
                continue;
            }
            fields = new ArrayList<Field>();
            fields.add(f);
            groupedFields.put(f.getIndices(), fields);
        }
        return groupedFields;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("AttRatingSystem", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }

    private void addRatingSystemField(Asset asset, String ratingSystem, List<Integer> indices) {
        Field ratingSystemField = new Field(RATING_SYSTEM_XPATH, ratingSystem);
        ratingSystemField.setIndices(indices);
        asset.addField(ratingSystemField);
    }
}

