/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.normalization;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FixMPAARatings
implements CustomNormalizationRule {
    private static final String TITLE = "TITLE";
    private static final String MOVIE = "MOVIE";
    private static final String RATING_VALUE_XPATH = "/tns:Fields/tns:Rating/tns:Value";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        RuleResults result = new RuleResults(title);
        this.changeRating(title, TITLE);
        this.changeRating(title, MOVIE);
        return result;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("AttFixMPAARatings", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }

    private void changeRating(Title title, String assetType) {
        List ratingValueFields = title.getAsset().getAllFieldsForXpath(assetType, RATING_VALUE_XPATH);
        Map<List<Integer>, List<Field>> groupedFields = this.groupByIndices(ratingValueFields);
        for (List<Field> rating : groupedFields.values()) {
            Field ratingSystem;
            Field ratingValue;
            if (rating.size() != 2) continue;
            if (rating.get(0).getTtvXPath().equals(RATING_VALUE_XPATH)) {
                ratingValue = rating.get(0);
                ratingSystem = rating.get(1);
            } else {
                ratingValue = rating.get(1);
                ratingSystem = rating.get(0);
            }
            if (ratingSystem.getValue().trim().isEmpty() || ratingValue.getValue().trim().isEmpty()) continue;
            if (ratingSystem.getValue().equals("PG") && ratingValue.getValue().equals("13")) {
                ratingValue.setValue("PG-13");
                ratingSystem.setValue("MPAA");
                continue;
            }
            if (!ratingSystem.getValue().equals("NC") || !ratingValue.getValue().equals("17")) continue;
            ratingValue.setValue("NC-17");
            ratingSystem.setValue("MPAA");
        }
    }

    private Map<List<Integer>, List<Field>> groupByIndices(List<Field> ratingValueFields) {
        HashMap<List<Integer>, List<Field>> groupedFields = new HashMap<List<Integer>, List<Field>>();
        for (Field f : ratingValueFields) {
            List<Field> fields;
            if (groupedFields.containsKey(f.getIndices())) {
                fields = (List)groupedFields.get(f.getIndices());
                fields.add(f);
                groupedFields.put(f.getIndices(), fields);
                continue;
            }
            fields = new ArrayList<Field>();
            fields.add(f);
            groupedFields.put(f.getIndices(), fields);
        }
        return groupedFields;
    }
}

