/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.deployment.scom;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;

public class FileUtil {
    public static FileFilter fileNamePatternMatchFilter(final String regex) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.matches(regex);
            }
        };
    }

    public static FilenameFilter fileNamePatternMatchFilter(final Pattern pattern) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        };
    }

    public static void sortByDate(File[] files, final boolean asc) {
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                long diff = file1.lastModified() - file2.lastModified();
                if (diff == 0L) {
                    return 0;
                }
                if (diff > 0L) {
                    return asc ? 1 : -1;
                }
                return asc ? -1 : 1;
            }
        };
        Arrays.sort(files, comparator);
    }
}

