/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.deployment.scom;

import com.ericsson.cms.sites.monitoring.config.ConfigUtils;
import com.ericsson.cms.sites.monitoring.config.ConfigurationException;
import com.ericsson.cms.sites.monitoring.config.ConfigurationPropertyKeys;
import com.ericsson.cms.sites.monitoring.config.IStatusPluginConfiguration;
import com.ericsson.cms.sites.monitoring.config.PropertyFileConfigurationParser;
import com.ericsson.cms.sites.monitoring.deployment.scom.ScomStatusConfiguration;
import java.util.Properties;
import org.apache.axis.utils.StringUtils;

public class ScomPluginConfigurationParser<T>
extends PropertyFileConfigurationParser {
    @Override
    protected IStatusPluginConfiguration validateProperties(Properties properties) throws ConfigurationException {
        ConfigUtils.validatePropertyNotEmpty(properties, ConfigurationPropertyKeys.CONFIGURATION_ID.toString());
        ConfigUtils.validatePropertyNotEmpty(properties, ConfigurationPropertyKeys.ENDPOINT_URL.toString());
        ConfigUtils.validateFolderExists(properties, ConfigurationPropertyKeys.ENDPOINT_URL.toString());
        ConfigUtils.validatePropertyNotEmpty(properties, ConfigurationPropertyKeys.CONFIGURATION_DISPLAY_NAME.toString());
        ScomStatusConfiguration statusConfig = new ScomStatusConfiguration();
        statusConfig.setConfigurationDisplayName(properties.getProperty(ConfigurationPropertyKeys.CONFIGURATION_DISPLAY_NAME.toString()));
        statusConfig.setConfigurationId(properties.getProperty(ConfigurationPropertyKeys.CONFIGURATION_ID.toString()));
        statusConfig.setEndpointUrl(properties.getProperty(ConfigurationPropertyKeys.ENDPOINT_URL.toString()));
        statusConfig.setPollInterval(ConfigUtils.parseLong(properties.getProperty(ConfigurationPropertyKeys.POLL_INTERVAL.toString())));
        if (StringUtils.isEmpty((String)properties.getProperty(ConfigurationPropertyKeys.FILE_COPY_COMPLETION_CHECK_INTERVAL.toString()))) {
            statusConfig.setFileCopyCompletionCheckInterval(0L);
        } else {
            statusConfig.setFileCopyCompletionCheckInterval(ConfigUtils.parseLong(properties.getProperty(ConfigurationPropertyKeys.FILE_COPY_COMPLETION_CHECK_INTERVAL.toString())));
        }
        return statusConfig;
    }
}

