/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.deployment.scom;

import com.ericsson.cms.sites.core.entities.TrackingStatus;
import com.ericsson.cms.sites.monitoring.config.PluginParseException;
import com.ericsson.cms.sites.monitoring.deployment.DeploymentAssetStatusBean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScomStatusParser {
    private static final String startedPatternStr = "^Auto deployment of asset (.*)-(.*) started on cluster (.*)";
    private static final String deployedPatternStr = "^Asset deployed to cluster completed. Asset: (.*)-(.*). Cluster: (.*)";
    private static final String failedPatternStr = "^Failed creating cluster job for asset (.*)-(.*) on cluster (.*)";
    private static final Pattern startedPattern = Pattern.compile("^Auto deployment of asset (.*)-(.*) started on cluster (.*)");
    private static final Pattern deployedPattern = Pattern.compile("^Asset deployed to cluster completed. Asset: (.*)-(.*). Cluster: (.*)");
    private static final Pattern failedPattern = Pattern.compile("^Failed creating cluster job for asset (.*)-(.*) on cluster (.*)");
    private static final int PROVIDER_ID_GROUP_NUMBER = 1;
    private static final int ASSET_ID_GROUP_NUMBER = 2;
    private static final int EXT_ID_GROUP_NUMBER = 3;

    public DeploymentAssetStatusBean parse(String desc, DeploymentAssetStatusBean info) throws PluginParseException {
        DeploymentAssetStatusBean statusBean;
        block5: {
            statusBean = null;
            try {
                statusBean = (DeploymentAssetStatusBean)info.clone();
                Matcher m = null;
                m = startedPattern.matcher(desc);
                if (m.matches()) {
                    String providerID = m.group(1);
                    String assetId = m.group(2);
                    String extId = ScomStatusParser.extractClusterId(m.group(3));
                    String status = TrackingStatus.DEPLOYMENT_IN_PROGRESS.name();
                    statusBean.setAssetID(assetId);
                    statusBean.setExtSiteid(extId);
                    statusBean.setProviderID(providerID);
                    statusBean.setStatus(status);
                    break block5;
                }
                m = deployedPattern.matcher(desc);
                if (m.matches()) {
                    String providerID = m.group(1);
                    String assetId = m.group(2);
                    String extId = ScomStatusParser.extractClusterId(m.group(3));
                    String status = TrackingStatus.DEPLOYED.name();
                    statusBean.setAssetID(assetId);
                    statusBean.setExtSiteid(extId);
                    statusBean.setProviderID(providerID);
                    statusBean.setStatus(status);
                    break block5;
                }
                m = failedPattern.matcher(desc);
                if (m.matches()) {
                    String providerID = m.group(1);
                    String assetId = m.group(2);
                    String extId = ScomStatusParser.extractClusterId(m.group(3));
                    String status = TrackingStatus.DEPLOYMENT_FAILED.name();
                    statusBean.setAssetID(assetId);
                    statusBean.setExtSiteid(extId);
                    statusBean.setProviderID(providerID);
                    statusBean.setStatus(status);
                    break block5;
                }
                throw new PluginParseException("No Pattern match For String");
            }
            catch (Exception e) {
                throw new PluginParseException("Unparseable Scom Status Record: " + desc, e);
            }
        }
        return statusBean;
    }

    private static String extractClusterId(String str) {
        int firstIndexOfSpace;
        String clean = str;
        int firstIndexOfDot = str.indexOf(46);
        if (firstIndexOfDot != -1) {
            clean = clean.substring(0, firstIndexOfDot);
        }
        if ((firstIndexOfSpace = clean.indexOf(32)) != -1) {
            clean = clean.substring(0, firstIndexOfSpace);
        }
        return clean;
    }

    public static void main(String[] args) {
        System.out.println(ScomStatusParser.extractClusterId("45de00d6-9413-4a19-82bd-bd89cb11ce95 .   .."));
    }
}

