/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.deployment.scom;

import com.ericsson.cms.sites.monitoring.common.IStatusQueryThread;
import com.ericsson.cms.sites.monitoring.common.SingleTaskTimer;
import com.ericsson.cms.sites.monitoring.config.ConfigurationManager;
import com.ericsson.cms.sites.monitoring.config.IStatusPluginConfiguration;
import com.ericsson.cms.sites.monitoring.deployment.DeploymentStatusPluginBase;
import com.ericsson.cms.sites.monitoring.deployment.scom.ScomPluginConfigurationParser;
import com.ericsson.cms.sites.monitoring.deployment.scom.ScomStatusConfiguration;
import com.ericsson.cms.sites.monitoring.deployment.scom.ScomStatusThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.java.plugin.registry.PluginDescriptor;

public class ScomStatusPlugin
extends DeploymentStatusPluginBase {
    private static final Logger logger = Logger.getLogger((String)ScomStatusPlugin.class.getName());

    @Override
    protected synchronized void _start() {
        try {
            logger.info((Object)"In ScomStatusPlugin._start()...");
            if (this.started) {
                logger.warn((Object)"In ScomStatusPlugin Already started");
                return;
            }
            this.multiConfiguration.clear();
            this.timerMap.clear();
            ClassLoader loader = this.getClass().getClassLoader();
            PluginDescriptor desc = this.getDescriptor();
            this.locateHomeDirectories(loader, desc);
            if (!this.tempDirectory.exists()) {
                this.tempDirectory.mkdir();
            }
            this.configurationManager = new ConfigurationManager();
            this.configParser = new ScomPluginConfigurationParser();
            this.configMap = this.configurationManager.configure(this.configDirectory, this.configParser);
            this.validateNoDuplicatePaths(this.configMap);
            this.multiConfiguration = ScomStatusPlugin.translateConfig(this.configMap);
            this.startTimers(this.configMap);
        }
        catch (Exception ex) {
            logger.error((Object)"Error Starting new configuration threads", (Throwable)ex);
            this.stopAllTimers();
            this.started = false;
            return;
        }
        this.started = true;
        for (String configurationId : this.multiConfiguration.keySet()) {
            Collection<String> externalIds = this.getMonitoredExternalSiteIds(configurationId);
            SingleTaskTimer t = (SingleTaskTimer)this.timerMap.get(configurationId);
            if (t == null || externalIds == null || externalIds.size() <= 0 || t.getTask() == null) continue;
            ((IStatusQueryThread)t.getTask()).getExternalIds().addAll(externalIds);
        }
    }

    @Override
    protected synchronized void startTimers(Map<String, IStatusPluginConfiguration> selectedConfigMap) {
        for (String key : selectedConfigMap.keySet()) {
            ScomStatusConfiguration config = (ScomStatusConfiguration)selectedConfigMap.get(key);
            File dataFileDir = new File(config.getEndpointUrl());
            long fileCopyCompeletionWaitTime = config.getFileCopyCompletionCheckInterval();
            ScomStatusThread thread = new ScomStatusThread(dataFileDir, fileCopyCompeletionWaitTime);
            thread.setId(key);
            thread.setListener(this);
            SingleTaskTimer<ScomStatusThread> timer = new SingleTaskTimer<ScomStatusThread>(config.getPollInterval(), thread);
            timer.start();
            this.timerMap.put(key, timer);
            logger.info((Object)String.format("Started Thread: %s for configuration ID: %s%n", thread.getId(), key));
        }
    }

    @Override
    public void startMonitoring(String configId, Collection<String> externalIds) {
        SingleTaskTimer timer = (SingleTaskTimer)this.timerMap.get(configId);
        if (timer != null) {
            Set<String> configExternalIds = ((IStatusQueryThread)timer.getTask()).getExternalIds();
            configExternalIds.addAll(externalIds);
            this.persistMonitoredExternalSiteIds(configId, configExternalIds);
        } else {
            logger.warn((Object)("Could not start monitoring configId: " + configId));
        }
    }

    @Override
    public void stopMonitoring(String configId, Collection<String> externalIds, boolean dissociatedFlag) {
        SingleTaskTimer timer = (SingleTaskTimer)this.timerMap.get(configId);
        if (timer != null && dissociatedFlag) {
            Set<String> configExternalIds = ((IStatusQueryThread)timer.getTask()).getExternalIds();
            configExternalIds.removeAll(externalIds);
            this.persistMonitoredExternalSiteIds(configId, configExternalIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistMonitoredExternalSiteIds(String configurationId, Collection<String> configExternalIds) {
        String filename;
        File externalIdsFile;
        if (this.tempDirectory != null && (!(externalIdsFile = new File(this.tempDirectory, filename = ScomStatusPlugin.getExternalSiteRepositoryFilename(configurationId))).exists() || externalIdsFile.canWrite())) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(externalIdsFile);
                for (String extId : configExternalIds) {
                    writer.println(extId);
                }
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)"Cannot presist External Site Ids", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.flush();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot Flush Stream", (Throwable)e);
                    }
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot Close File", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getMonitoredExternalSiteIds(String configurationId) {
        String filename = ScomStatusPlugin.getExternalSiteRepositoryFilename(configurationId);
        File externalIdsFile = new File(this.tempDirectory, filename);
        ArrayList<String> configExternalIds = new ArrayList<String>();
        if (this.tempDirectory != null && externalIdsFile.exists() && externalIdsFile.canRead()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(externalIdsFile));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    configExternalIds.add(line);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error Reading External Site Ids", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot Close File", (Throwable)e);
                    }
                }
            }
        }
        return configExternalIds;
    }

    private static String getExternalSiteRepositoryFilename(String configurationId) {
        return String.format("external_site_ids_%s.%s", configurationId, "data");
    }
}

