/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.deployment.scom;

import com.ericsson.cms.sites.monitoring.common.FileUtils;
import com.ericsson.cms.sites.monitoring.common.IAssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IStatusListener;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryThread;
import com.ericsson.cms.sites.monitoring.deployment.DeploymentAssetStatusBean;
import com.ericsson.cms.sites.monitoring.deployment.scom.FileUtil;
import com.ericsson.cms.sites.monitoring.deployment.scom.FilterChain;
import com.ericsson.cms.sites.monitoring.deployment.scom.ScomStatusParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ScomStatusThread
implements IStatusQueryThread {
    String url;
    Date lastUpdate = null;
    Set<String> externalIds = Collections.synchronizedSet(new HashSet());
    IStatusQueryServiceFacade queryService = null;
    IStatusListener listener = null;
    private List<IAssetStatusBean> statusChangesList = Collections.synchronizedList(new ArrayList());
    private String id = null;
    private File dataFileDir;
    private static final Logger logger = Logger.getLogger((String)ScomStatusThread.class.getName());
    private ScomStatusParser parser = new ScomStatusParser();
    private static final String validSecond = "(0[0-9]|[12345][0-9])";
    private static final String validMinute = "(0[0-9]|[12345][0-9])";
    private static final String validHour = "(0[0-9]|[1][0-9]|[2][0-3])";
    private static final String validDay = "(0[1-9]|[12][0-9]|3[01])";
    private static final String validMonth = "(0[1-9]|1[012])";
    private static final String validYear = "(19|20)\\d\\d";
    private static final String fileNameMatchExp = String.format("%s%s%s%s%s%s-SCOMEvents.txt", "(19|20)\\d\\d", "(0[1-9]|1[012])", "(0[1-9]|[12][0-9]|3[01])", "(0[0-9]|[1][0-9]|[2][0-3])", "(0[0-9]|[12345][0-9])", "(0[0-9]|[12345][0-9])");
    private static final DateFormat fileNameDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    FileFilter fileNamePatternFilter = FileUtil.fileNamePatternMatchFilter(fileNameMatchExp);
    private long fileCopyCompeletionWaitTime;
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");

    public ScomStatusThread(File dataFileDir, long fileCopyCompeletionWaitTime) {
        this.dataFileDir = dataFileDir;
        this.fileCopyCompeletionWaitTime = fileCopyCompeletionWaitTime <= 0L ? 100L : fileCopyCompeletionWaitTime;
        logger.warn((Object)"fileCopyCompeletionWaitTime is set to zero. Setting to 100 milliseconds");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public IStatusListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(IStatusListener listener) {
        this.listener = listener;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public Set<String> getExternalIds() {
        return this.externalIds;
    }

    @Override
    public void setExternalIds(Set<String> externalIds) {
        this.externalIds = externalIds;
    }

    @Override
    public IStatusQueryServiceFacade getQueryService() {
        return this.queryService;
    }

    @Override
    public void setQueryService(IStatusQueryServiceFacade queryService) {
        this.queryService = queryService;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void execute() {
        this.listener.callStarted(this);
        if (this.externalIds.size() == 0) {
            logger.debug((Object)String.format("No external Ids. Existing run() for thread id: %s without making weservice call.%n", this.id));
        }
        try {
            FilterChain filterChain = new FilterChain(this.fileNamePatternFilter);
            File[] files = this.dataFileDir.listFiles(filterChain);
            if (files == null || files.length == 0) {
                return;
            }
            FileUtils.sortByFileName(files, true);
            for (File file : files) {
                boolean deleted;
                this.waitForFileCopyCompletion(file);
                this.getAssetStatus(file);
                if (this.listener != null && this.statusChangesList.size() > 0) {
                    this.listener.statusChanged(this, this.statusChangesList);
                }
                if (deleted = file.delete()) continue;
                logger.error((Object)("Could not delete the file: " + file));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while querying service to get results: ", (Throwable)e);
        }
        this.listener.callCompleted(this);
    }

    private void waitForFileCopyCompletion(File file) {
        try {
            long previousLastModifiedDate = 0L;
            long previousLength = 0L;
            long currentLastModifiedDate = file.lastModified();
            long currentLength = file.length();
            do {
                previousLastModifiedDate = currentLastModifiedDate;
                previousLength = currentLength;
                Thread.sleep(this.fileCopyCompeletionWaitTime);
                currentLastModifiedDate = file.lastModified();
                currentLength = file.length();
            } while (previousLastModifiedDate != currentLastModifiedDate || previousLength != currentLength);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Error while Sleeping: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAssetStatus(File file) {
        BufferedReader buff = null;
        try {
            String line;
            buff = new BufferedReader(new FileReader(file));
            this.statusChangesList.clear();
            HashMap<String, Date> assetDate = new HashMap<String, Date>();
            HashMap<String, DeploymentAssetStatusBean> assetBean = new HashMap<String, DeploymentAssetStatusBean>();
            while ((line = buff.readLine()) != null) {
                if (line.trim().length() == 0) {
                    logger.debug((Object)"Skipping empty line");
                    continue;
                }
                String[] fields = line.split("\\|");
                if (fields.length < 3) {
                    String msg = String.format("Wrong number of tokens in line %s. Skipping the line", line);
                    logger.warn((Object)msg);
                    continue;
                }
                try {
                    DeploymentAssetStatusBean scomAssetStatusBean = new DeploymentAssetStatusBean();
                    String dateString = fields[0];
                    String eventId = fields[1];
                    String desc = fields[2];
                    Date eventDate = df.parse(dateString);
                    scomAssetStatusBean.setTimestamp(eventDate.getTime());
                    scomAssetStatusBean = this.parser.parse(desc, scomAssetStatusBean);
                    String providerIdAssetId = scomAssetStatusBean.getProviderID() + "-" + scomAssetStatusBean.getAssetID();
                    if (assetDate.containsKey(providerIdAssetId)) {
                        Date previousEventDate = (Date)assetDate.get(providerIdAssetId);
                        if (!eventDate.after(previousEventDate)) continue;
                        assetDate.put(providerIdAssetId, eventDate);
                        assetBean.put(providerIdAssetId, scomAssetStatusBean);
                        continue;
                    }
                    assetDate.put(providerIdAssetId, eventDate);
                    assetBean.put(providerIdAssetId, scomAssetStatusBean);
                }
                catch (Exception ex) {
                    String msg = String.format("Error while parsing the line %s.", line);
                    logger.error((Object)msg, (Throwable)ex);
                }
            }
            for (DeploymentAssetStatusBean bean : assetBean.values()) {
                if (!this.externalIds.contains(bean.getExtSiteid())) continue;
                logger.debug((Object)("Adding bean: " + bean.toString()));
                this.statusChangesList.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while reading csv file: ", (Throwable)ex);
        }
        finally {
            if (buff != null) {
                try {
                    buff.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while closing csv file: ", (Throwable)ex);
                }
            }
        }
    }
}

