/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.validation;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.custom.validation.FieldTreeHelper;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.cms.rules.customrules.CustomValidationRule;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ProducerNameValidation
implements CustomValidationRule {
    public boolean evalulteCriteria(Map<String, Object> parameters, Title title) {
        List<FieldTree> fieldTrees = FieldTreeHelper.breakApartFieldTree(title.getAsset().getFieldTreeForXpath("TITLE", FieldTreeHelper.SOURCE));
        for (FieldTree source : fieldTrees) {
            List fields = source.depthFirstTraversal();
            String firstName = "";
            String lastName = "";
            boolean isProducer = false;
            for (Field f : fields) {
                if (f.getTtvXPath().equals(FieldTreeHelper.FIRST_NAME)) {
                    firstName = f.getValue();
                    continue;
                }
                if (f.getTtvXPath().equals(FieldTreeHelper.LAST_NAME)) {
                    lastName = f.getValue();
                    continue;
                }
                if (!f.getTtvXPath().equals(FieldTreeHelper.ROLE_NAME) || !f.getValue().equals(FieldTreeHelper.PRODUCER)) continue;
                isProducer = true;
            }
            if (!isProducer || lastName.length() + firstName.length() <= 91) continue;
            return true;
        }
        return false;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("producerNameValidation", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

