package com.tandbergtv.metadatamanager.specimpl.mstv2;

import java.util.HashMap;
import java.util.Map;

import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;

public class MSTV2Identifier extends IdentifierBase {

	private static final long serialVersionUID = 1240862770858580776L;
	/* xpaths of the identifying fields in MSTV spec. */
	private static String PROVIDERID_XPATH = "assetPackages/assetPackage/providerID";
	private static String ASSETID_XPATH = "assetPackages/assetPackage/metadata/assetID";

	/* stores values for identifying fields in MSTV spec */
	private String providerId;
	private String assetId;

	/**
	 * @return the providerId
	 */
	public String getProviderId() {
		return providerId;
	}

	/**
	 * @param providerId
	 *            the providerId to set
	 */
	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	/**
	 * @return the assetId
	 */
	public String getAssetId() {
		return assetId;
	}

	/**
	 * @param assetId
	 *            the assetId to set
	 */
	public void setAssetId(String assetId) {
		this.assetId = assetId;
	}

	public Map<String, String> getSpecIdentifiers() {
		Map<String, String> map = new HashMap<String, String>();
		map.put(PROVIDERID_XPATH, providerId);
		map.put(ASSETID_XPATH, assetId);
		return map;
	}

	public void setSpecIdentifiers(Map<String, String> identifiers) {
		if (identifiers.containsKey(ASSETID_XPATH)) {
			setAssetId(identifiers.get(ASSETID_XPATH));
		}
		if (identifiers.containsKey(PROVIDERID_XPATH)) {
			setProviderId(identifiers.get(PROVIDERID_XPATH));
		}
	}

	public Map<String, String> getTTVPaths() {
		Map<String, String> ttvPaths = new HashMap<String, String>();

		String assetIdXpath = MappingFileParser.getMapping(
				getMappingResourceUrl(), ASSETID_XPATH);
		if (assetIdXpath.trim().length() == 0) {
			throw new RuntimeException("Identifying field: " + ASSETID_XPATH
					+ " cannot be mapped to TTV xpath.");
		}
		String providerIdXpath = MappingFileParser.getMapping(
				getMappingResourceUrl(), PROVIDERID_XPATH);
		if (providerIdXpath.trim().length() == 0) {
			throw new RuntimeException("Identifying field: " + PROVIDERID_XPATH
					+ " cannot be mapped to TTV xpath.");
		}

		ttvPaths.put(ASSETID_XPATH, assetIdXpath);
		ttvPaths.put(PROVIDERID_XPATH, providerIdXpath);
		return ttvPaths;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isValidIdentifier() {
		if (providerId != null && !providerId.equals("")) {
			if (assetId != null && !assetId.equals("")) {
				return true;
			}
		}
		return false;
	}
	
	@Override
	public boolean equals(Object o) {
		if(this == o)
			return true;
		
		if(!(o instanceof MSTV2Identifier))
			return false;
		
		MSTV2Identifier another = (MSTV2Identifier) o;
		
		return (isEqual(providerId, another.providerId) &&
				isEqual(assetId, another.assetId));
	}
	
	private boolean isEqual(String s1, String s2) {
		return (s1 == null) ? s2 == null : s1.equals(s2);
	}
	
	@Override
	public int hashCode() {
		int h1 = (providerId != null) ? providerId.hashCode() : 0;
		int h2 = (assetId != null) ? assetId.hashCode() : 0;
				
		return (h1 + h2 + 7) * 13;
	}
	
	@Override
	public String toString() {
		return providerId + " | " + assetId ;
	}
}
