package com.tandbergtv.metadatamanager.specimpl.mstv2;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;

/**
 * Handler for MSTV spec.
 * @author spuranik
 * 
 */
public class MSTV2SpecHandler extends SingleTitleSpecHandler {

	private static final String MSTV_ROOTELEMENT_NAME = "assetPackages";

	public MSTV2SpecHandler() {
		super();
		this.spec = Spec.MSTV2;
		this.rootElementName = MSTV_ROOTELEMENT_NAME;
	}

	@Override
	public IIdentifier extractId(Asset asset) {
		MSTV2Identifier id = new MSTV2Identifier();
		id.setMappingResourceUrl(getMappingResourceUrl());

		// set search service
		id.setSearchService(getSearchService());

		// extract the id values after getting the ttvxpaths for the id fields.
		Map<String, String> idValues = new HashMap<String, String>();
		Map<String, String> idXPaths = id.getTTVPaths();
		Iterator<Entry<String, String>> iter = idXPaths.entrySet().iterator();
		while (iter.hasNext()) {
			Entry<String, String> entry = iter.next();

			Field f = asset.getFirstField(entry.getValue());
			if (f != null) {
				idValues.put(entry.getKey(), f.getValue());
			}
		}
		// set these values in the id.
		id.setSpecIdentifiers(idValues);
		return id;
	}


	@Override
	public IdentifierBase getIdentifier() {
		MSTV2Identifier identifier = new MSTV2Identifier();
		identifier.setSearchService(searchService);
		identifier.setMappingResourceUrl(mappingResourceUrl);
		
		return identifier;
	}

}
