<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	version="1.0">
	
	<xsl:output method="xml" indent="yes"/>

	<!-- language_optional -->
	<xsl:template match="App_Data[@Name = 'TitleArtist'] 
							| App_Data[@Name = 'SongTitle']
							| App_Data[@Name = 'TitleLanguage']
							| App_Data[@Name = 'L2V_Platform']
							| App_Data[@Name = 'L2V_Platform_List']
							| App_Data[@Name = 'L2V_PP_PACKAGE']
							| App_Data[@Name = 'L2V_Platform_UVerse_License_Start']
							| App_Data[@Name = 'L2V_Platform_UVerse_License_End']
							| App_Data[@Name = 'L2V_Remove_Ads_UVerse']
							| App_Data[@Name = 'L2V_Recording_UVerse_Rights']
							| App_Data[@Name = 'L2V_Platform_WM7_License_Start']
							| App_Data[@Name = 'L2V_Platform_WM7_License_End']
							| App_Data[@Name = 'L2V_Remove_Ads_WM7']
							| App_Data[@Name = 'L2V_Recording_WM7_Rights']
							| App_Data[@Name = 'L2V_QC_Required']
							| App_Data[@Name = 'L2V_STATION_AFFIL']
							| App_Data[@Name = 'L2V_STATION_NUM']
							| App_Data[@Name = 'L2V_HEADEND_ID'] 
							| App_Data[@Name = 'SSTR_PROFILE'] 
							| App_Data[@Name = 'TSTV_Capture']
							| App_Data[@Name = 'TV_MANUAL_INT']
							| App_Data[@Name = 'TV_TEMPLATE_TEST'] 
							| App_Data[@Name = 'TV_ENC_PROFILE']
							| App_Data[@Name = 'Repeat']
							| App_Data[@Name = 'L2V_HEADEND_TIMEZONE']
							| App_Data[@Name = 'WR_WindowLicensingModel'] " mode="mappedCustomFields_optional">
		<xsl:element name="tns:CustomField">
			<xsl:attribute name="name">
				<xsl:value-of select="@Name" />
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@Name = 'L2V_Remove_Ads_UVerse' 
										or @Name = 'L2V_Remove_Ads_WM7' 
										or @Name = 'L2V_QC_Required' 
										or @Name = 'TV_MANUAL_INT' 
										or @Name = 'TV_TEMPLATE_TEST'
										or @Name = 'Repeat' ">
						<xsl:choose>
							<xsl:when test="fn:lower-case(@Value) = 'y'">true</xsl:when>
							<xsl:when test="@Value = ''"></xsl:when>
							<xsl:otherwise>false</xsl:otherwise>
						</xsl:choose>
				    </xsl:when>
				    <xsl:otherwise>
				    	<xsl:value-of select="@Value" />
				    </xsl:otherwise>
			    </xsl:choose>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

	<xsl:template match="App_Data[@Name='CL11_Trial'] | App_Data[@Name='CL11_Trial2']" mode="unMappedCustomFields_optional">
		<xsl:element name="tns:CustomField">
			<xsl:attribute name="name">
				<xsl:value-of select="@Name" />
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:value-of select="@Value" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
