<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	version="1.0">
	
<xsl:template name="FormatDate">
    <xsl:param name="DateTime" />
    <!-- new date format 2006-01-14T08:55:22 -->
    <xsl:variable name="mo">
      <xsl:value-of select="substring($DateTime,1,2)" />
    </xsl:variable>
    <xsl:variable name="date-temp">
      <xsl:value-of select="substring-after($DateTime,'-')" />
    </xsl:variable>
    <xsl:variable name="date">
      <xsl:value-of select="substring-before($date-temp,'-')" />
    </xsl:variable>
    <xsl:variable name="year-temp">
      <xsl:value-of select="substring-after($date-temp,'-')" />
    </xsl:variable>
    <xsl:variable name="year">
      <xsl:value-of select="substring($year-temp,1,4)" />
    </xsl:variable>
    <xsl:variable name="time">
      <xsl:value-of select="substring-after($year-temp,'T')" />
    </xsl:variable>
    <xsl:variable name="hh">
      <xsl:value-of select="substring($time,1,2)" />
    </xsl:variable>
    <xsl:variable name="mm">
      <xsl:value-of select="substring($time,4,2)" />
    </xsl:variable>
    <xsl:variable name="ss">
      <xsl:value-of select="substring($time,7,2)" />
    </xsl:variable>
    <xsl:value-of select="$year"/>
    <xsl:value-of select="'-'"/>
    <xsl:value-of select="$mo"/>
    <xsl:value-of select="'-'"/>
    <xsl:if test="(string-length($date) &lt; 2)">
      <xsl:value-of select="0"/>
    </xsl:if>

    <xsl:value-of select="$date"/>

    <xsl:value-of select="'T'"/>

    <xsl:value-of select="$hh"/>

    <xsl:value-of select="':'"/>

    <xsl:value-of select="$mm"/>

    <xsl:value-of select="':'"/>

    <xsl:value-of select="$ss"/>

  </xsl:template>
  
 </xsl:stylesheet>