<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:tns="http://www.tandbergtv.com/TTVSchema" xmlns:xs="http://www.w3.org/2001/XMLSchema" version="1.0">
	<xsl:import href="to/date.xsl"/>
	<xsl:output method="xml" indent="yes"/>

	<!-- Title -->
	<xsl:template match="AMS" mode="title">
		<tns:CreationInfo>
			<tns:CreateDate><xsl:value-of select="@Creation_Date" /></tns:CreateDate>
			<xsl:if test="../App_Data/@Name = 'Year' or ../App_Data/@Name = 'L2V_ORG_AIR_DATE'">
				<tns:PublicationDate>
					<xsl:if test="../App_Data/@Name = 'Year'">
						<xsl:value-of select="../App_Data[@Name = 'Year']/@Value" />
					</xsl:if>
					<xsl:if test="../App_Data/@Name = 'L2V_ORG_AIR_DATE'">
						<xsl:value-of select="substring(../App_Data[@Name = 'L2V_ORG_AIR_DATE']/@Value,7,4)" />
					</xsl:if>
				</tns:PublicationDate>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Studio' or ../App_Data/@Name = 'Studio_Name' or ../App_Data/@Name = 'Studio_Code' or ../App_Data/@Name = 'Studio_Royalty_Percent' or ../App_Data/@Name = 'Studio_Royalty_Minimum' or ../App_Data/@Name = 'Studio_Royalty_Flat_Rate'">
				<tns:Studio>
					<xsl:if test="../App_Data/@Name = 'Studio'">
						<tns:DisplayName><xsl:value-of select="../App_Data[@Name = 'Studio']/@Value" /></tns:DisplayName>
					</xsl:if>
					<xsl:if test="../App_Data/@Name = 'Studio_Name'">
						<tns:Name><xsl:value-of select="../App_Data[@Name = 'Studio_Name']/@Value" /></tns:Name>
					</xsl:if>
					<xsl:if test="../App_Data/@Name = 'Studio_Code'">
						<tns:Code><xsl:value-of select="../App_Data[@Name = 'Studio_Code']/@Value" /></tns:Code>
					</xsl:if>
					<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Percent' or ../App_Data/@Name = 'Studio_Royalty_Minimum' or ../App_Data/@Name = 'Studio_Royalty_Flat_Rate'">
						<tns:RoyaltyInfo>
							<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Percent'">
								<tns:RoyaltyPercent><xsl:value-of select="../App_Data[@Name = 'Studio_Royalty_Percent']/@Value" /></tns:RoyaltyPercent>
							</xsl:if>
							<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Minimum'">
								<tns:RoyaltyMinimum><xsl:value-of select="../App_Data[@Name = 'Studio_Royalty_Minimum']/@Value" /></tns:RoyaltyMinimum>
							</xsl:if>
							<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Flat_Rate'">
								<tns:RoyaltyFlatRate><xsl:value-of select="../App_Data[@Name = 'Studio_Royalty_Flat_Rate']/@Value" /></tns:RoyaltyFlatRate>
							</xsl:if>
						</tns:RoyaltyInfo>
					</xsl:if>
				</tns:Studio>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Country_of_Origin'">
				<tns:Place><tns:Country><xsl:value-of select="../App_Data[@Name = 'Country_of_Origin']/@Value" /></tns:Country></tns:Place>
			</xsl:if>
		</tns:CreationInfo>
		<!-- callsign trial use field -->
		<xsl:if test="../App_Data/@Name = 'L2V_CallSign' or ../App_Data/@Name = 'L2V_Season_Number' or ../App_Data/@Name = 'L2V_SERIES_ID' or ../App_Data/@Name = 'L2V_PROGRAM_ID' or ../App_Data/@Name = 'Start_Time_UTC' or ../App_Data/@Name = 'L2V_ORG_AIR_DATE'">
			<tns:TvId>
				<xsl:if test="../App_Data/@Name = 'L2V_CallSign'">
					<tns:CallSign>
						<xsl:value-of select="../App_Data[@Name = 'L2V_CallSign']/@Value" />
					</tns:CallSign>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'L2V_Season_Number'">
					<tns:EpisodeSeasonNumber>
						<xsl:value-of select="../App_Data[@Name = 'L2V_Season_Number']/@Value" />
					</tns:EpisodeSeasonNumber>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'L2V_SERIES_ID'">
					<tns:SeriesId>
						<xsl:value-of select="../App_Data[@Name = 'L2V_SERIES_ID']/@Value" />
					</tns:SeriesId>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'L2V_PROGRAM_ID'">
					<tns:ProgramId>
						<xsl:value-of select="../App_Data[@Name = 'L2V_PROGRAM_ID']/@Value" />
					</tns:ProgramId>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Start_Time_UTC' or ../App_Data/@Name = 'L2V_ORG_AIR_DATE'">
					<tns:Showtime>
						<xsl:if test="../App_Data/@Name = 'L2V_ORG_AIR_DATE'">
							<tns:OriginalAirDate>
								<xsl:call-template name="FormatDate">
		          					<xsl:with-param name="DateTime" select="../App_Data[@Name = 'L2V_ORG_AIR_DATE']/@Value"/>
		        				</xsl:call-template>
							</tns:OriginalAirDate>
						</xsl:if>
						<xsl:if test="../App_Data/@Name = 'Start_Time_UTC'">
							<tns:StartTimeInUtc>
								<xsl:choose>
									<xsl:when test="string-length(substring-before(../App_Data[@Name = 'Start_Time_UTC']/@Value,'-')) = 2">
										<xsl:call-template name="FormatDate">
				          					<xsl:with-param name="DateTime" select="../App_Data[@Name = 'Start_Time_UTC']/@Value"/>
				        				</xsl:call-template>
			        				</xsl:when>
			        				<xsl:otherwise>
			        					<xsl:value-of select="../App_Data[@Name = 'Start_Time_UTC']/@Value" />
			        				</xsl:otherwise>
			        			</xsl:choose>
							</tns:StartTimeInUtc>
						</xsl:if>
					</tns:Showtime>
				</xsl:if>
			</tns:TvId>
		</xsl:if>
		<xsl:if test="../App_Data/@Name = 'ISAN'">
			<tns:ISAN><xsl:value-of select="../App_Data[@Name = 'ISAN']/@Value" /></tns:ISAN>
		</xsl:if>
		<xsl:if test="../App_Data/@Name = 'Episode_Name' or ../App_Data/@Name = 'Episode_ID' or ../App_Data/@Name = 'Season_Premiere' or ../App_Data/@Name = 'Season_Finale'">
			<tns:Episode>
				<xsl:if test="../App_Data/@Name = 'Episode_Name'">
					<tns:Name><tns:Value><xsl:value-of select="../App_Data[@Name = 'Episode_Name']/@Value" /></tns:Value></tns:Name>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Episode_ID'">
					<tns:Number><xsl:value-of select="../App_Data[@Name = 'Episode_ID']/@Value" /></tns:Number>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Season_Premiere'">
					<tns:SeasonPremier>
						<xsl:if test="../App_Data[@Name = 'Season_Premiere']/@Value = 'Y'">true</xsl:if>
						<xsl:if test="../App_Data[@Name = 'Season_Premiere']/@Value = 'N'">false</xsl:if>
					</tns:SeasonPremier>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Season_Finale'">
					<tns:SeasonFinale>
						<xsl:if test="../App_Data[@Name = 'Season_Finale']/@Value = 'Y'">true</xsl:if>
						<xsl:if test="../App_Data[@Name = 'Season_Finale']/@Value = 'N'">false</xsl:if>
					</tns:SeasonFinale>
				</xsl:if>
			</tns:Episode>
		</xsl:if>
		<tns:Rating>
			<xsl:for-each select="../App_Data[@Name = 'Rating']">
				<tns:Value><xsl:value-of select="@Value" /></tns:Value>
			</xsl:for-each>
			<xsl:for-each select="../App_Data[@Name = 'MSORating']">
				<tns:MSORating><xsl:value-of select="@Value" /></tns:MSORating>
			</xsl:for-each>
			<xsl:for-each select="../App_Data[@Name = 'Advisories']">
				<tns:ContentAdvisory><xsl:value-of select="@Value" /></tns:ContentAdvisory>
			</xsl:for-each>
			<xsl:for-each select="../App_Data[@Name = 'Audience']">
				<tns:TargetAudience><xsl:value-of select="@Value" /></tns:TargetAudience>
			</xsl:for-each>
		</tns:Rating>
		<xsl:if test="../App_Data/@Name = 'Closed_Captioning'">
			<tns:Caption>
				<tns:Value>
					<xsl:if test="../App_Data[@Name = 'Closed_Captioning']/@Value = 'Y'">true</xsl:if>
					<xsl:if test="../App_Data[@Name = 'Closed_Captioning']/@Value = 'N'">false</xsl:if>
				</tns:Value>
			</tns:Caption>
		</xsl:if>
		<xsl:if test="../App_Data/@Name = 'Propagation_Priority'">
			<tns:PropagationPriority>
				<xsl:value-of select="../App_Data[@Name = 'Propagation_Priority']/@Value" />
			</tns:PropagationPriority>
		</xsl:if>
		
		<xsl:if test="../App_Data/@Name = 'Auto_Import'">
			<tns:AutoImport>
				<xsl:value-of select="../App_Data[@Name = 'Auto_Import']/@Value" />
			</tns:AutoImport>
		</xsl:if>					

		<xsl:if test="../App_Data/@Name = 'Auto_Deploy'">
			<tns:AutoDeploy>
				<xsl:value-of select="../App_Data[@Name = 'Auto_Deploy']/@Value" />
			</tns:AutoDeploy>
		</xsl:if>		

		<xsl:if test="../App_Data/@Name = 'Auto_Delete'">
			<tns:AutoDelete>
				<xsl:value-of select="../App_Data[@Name = 'Auto_Delete']/@Value" />
			</tns:AutoDelete>
		</xsl:if>		
		
		<tns:Duration>
			<tns:Duration><xsl:value-of select="../App_Data[@Name = 'Run_Time']/@Value" /></tns:Duration>
			<tns:DisplayDuration><xsl:value-of select="../App_Data[@Name = 'Display_Run_Time']/@Value" /></tns:DisplayDuration>
		</tns:Duration>
		<tns:Title>
			<tns:DisplayTitle><tns:Value><xsl:value-of select="../App_Data[@Name = 'Title']/@Value" /></tns:Value></tns:DisplayTitle>
			<tns:ShortTitle><tns:Value><xsl:value-of select="../App_Data[@Name = 'Title_Brief']/@Value" /></tns:Value></tns:ShortTitle>
			<xsl:if test="../App_Data/@Name = 'Title_Sort_Name'">
				<tns:SortTitle><tns:Value><xsl:value-of select="../App_Data[@Name = 'Title_Sort_Name']/@Value" /></tns:Value></tns:SortTitle>
			</xsl:if>
		</tns:Title>
		<tns:Summary>
			<xsl:if test="../App_Data/@Name = 'Summary_Long'">
				<tns:DisplaySummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Long']/@Value" /></tns:Value></tns:DisplaySummary>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Summary_Medium'">
				<tns:MediumSummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Medium']/@Value" /></tns:Value></tns:MediumSummary>
			</xsl:if>
			<tns:ShortSummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Short']/@Value" /></tns:Value></tns:ShortSummary>
		</tns:Summary>
		<xsl:for-each select="../App_Data[@Name = 'Actors']">
			<tns:Source>
				<tns:Role>
					<tns:Name>ACTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Actors_Display']">
			<tns:Source>
				<tns:Role>
					<tns:Name>ACTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<tns:DisplayName><xsl:value-of select="@Value" /></tns:DisplayName>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Writer_Display']">
			<tns:Source>
				<tns:Role>
					<tns:Name>WRITER</tns:Name>
				</tns:Role>
				<tns:Contact>
					<tns:DisplayName><xsl:value-of select="@Value" /></tns:DisplayName>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Director']">
			<tns:Source>
				<tns:Role>
					<tns:Name>DIRECTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Producers']">
			<tns:Source>
				<tns:Role>
					<tns:Name>PRODUCER</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Genre']">
			<tns:Genre>
				<tns:Value><xsl:value-of select="@Value" /></tns:Value>
			</tns:Genre>
		</xsl:for-each>
		<xsl:if test="../App_Data/@Name = 'Show_Type'">
			<tns:ShowType><xsl:value-of select="../App_Data[@Name = 'Show_Type']/@Value" /></tns:ShowType>
		</xsl:if>
		<xsl:for-each select="../App_Data[@Name = 'Chapter']">
			<tns:Chapter><xsl:value-of select="@Value" /></tns:Chapter>
		</xsl:for-each>
		<tns:Rights>
			<tns:LicensingWindowStart>
					<xsl:value-of select="../App_Data[@Name = 'Licensing_Window_Start']/@Value" />
			</tns:LicensingWindowStart>
			<tns:LicensingWindowEnd>
					<xsl:value-of select="../App_Data[@Name = 'Licensing_Window_End']/@Value" />
			</tns:LicensingWindowEnd>

			<xsl:for-each select="../App_Data[@Name = 'Subscriber_View_Limit']">
				<tns:MaxViewLimit><xsl:value-of select="@Value" /></tns:MaxViewLimit>
			</xsl:for-each>
			<xsl:if test="../App_Data/@Name = 'Preview_Period'">
				<xsl:element name="tns:PreviewPeriod">
					<xsl:element name="tns:Duration">
						<xsl:variable name="myValue" select="string(../App_Data[@Name = 'Preview_Period']/@Value)"/>
						<xsl:choose>
							<xsl:when test="not(string($myValue) castable as xs:integer) or number($myValue) &lt; 0  ">
								<xsl:value-of select="$myValue"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="format-number(floor(number($myValue) div 3600), '00')"/>:<xsl:value-of select="format-number( floor((number($myValue) - ( floor(number($myValue) div 3600 ) * 3600 ))  div 60), '00')"/>:<xsl:value-of select="format-number(number(../App_Data[@Name = 'Preview_Period']/@Value) mod 60, '00')"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:element>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Home_Video_Window'">
				<tns:HomeVideoWindow><xsl:value-of select="../App_Data[@Name = 'Home_Video_Window']/@Value" /></tns:HomeVideoWindow>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Display_As_New'">
				<tns:NewReleaseWindow><xsl:value-of select="../App_Data[@Name = 'Display_As_New']/@Value" /></tns:NewReleaseWindow>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Display_As_Last_Chance'">
				<tns:DisplayAsLastChance><xsl:value-of select="../App_Data[@Name = 'Display_As_Last_Chance']/@Value" /></tns:DisplayAsLastChance>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Maximum_Viewing_Length'">
				<tns:MaxViewingLimit><xsl:value-of select="number(substring-before(../App_Data[@Name = 'Maximum_Viewing_Length']/@Value, ':')) *  1440
				+ number(substring-before(substring-after(../App_Data[@Name = 'Maximum_Viewing_Length']/@Value, ':'), ':')) * 60
				+ number(substring-after(substring-after(../App_Data[@Name = 'Maximum_Viewing_Length']/@Value, ':'), ':'))" /></tns:MaxViewingLimit>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Contract_Name'">
				<tns:Contract>
					<tns:Name><xsl:value-of select="../App_Data[@Name = 'Contract_Name']/@Value" /></tns:Name>
				</tns:Contract>
			</xsl:if>
		</tns:Rights>
		<xsl:if test="../App_Data/@Name = 'Distributor_Name' or ../App_Data/@Name = 'Distributor_Royalty_Percent' or ../App_Data/@Name = 'Distributor_Royalty_Minimum' or ../App_Data/@Name = 'Distributor_Royalty_Flat_Rate'">
			<tns:Distributor>
				<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Percent' or ../App_Data/@Name = 'Distributor_Royalty_Minimum' or ../App_Data/@Name = 'Distributor_Royalty_Flat_Rate'">
					<tns:RoyaltyInfo>
						<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Percent'">
							<tns:RoyaltyPercent><xsl:value-of select="../App_Data[@Name = 'Distributor_Royalty_Percent']/@Value" /></tns:RoyaltyPercent>
						</xsl:if>
						<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Minimum'">
							<tns:RoyaltyMinimum><xsl:value-of select="../App_Data[@Name = 'Distributor_Royalty_Minimum']/@Value" /></tns:RoyaltyMinimum>
						</xsl:if>
						<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Flat_Rate'">
							<tns:RoyaltyFlatRate><xsl:value-of select="../App_Data[@Name = 'Distributor_Royalty_Flat_Rate']/@Value" /></tns:RoyaltyFlatRate>
						</xsl:if>
					</tns:RoyaltyInfo>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Distributor_Name'">
					<tns:Name><xsl:value-of select="../App_Data[@Name = 'Distributor_Name']/@Value" /></tns:Name>
				</xsl:if>
			</tns:Distributor>
		</xsl:if>
		<tns:BillingInfo>
			<tns:Identifier><tns:Id><xsl:value-of select="../App_Data[@Name = 'Billing_ID']/@Value" /></tns:Id></tns:Identifier>
			<xsl:if test="../App_Data/@Name = 'Suggested_Price'">
				<tns:SuggestedPrice>
					<tns:Value><xsl:value-of select="../App_Data[@Name = 'Suggested_Price']/@Value" /></tns:Value>
				</tns:SuggestedPrice>
			</xsl:if>
		</tns:BillingInfo>
		<xsl:if test="../App_Data/@Name = 'Box_Office'">
			<tns:BoxOffice>
				<tns:Value><xsl:value-of select="../App_Data[@Name = 'Box_Office']/@Value" /></tns:Value>
			</tns:BoxOffice>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="count(../App_Data[@Name = 'L2V_Category1']) = 0">
				<xsl:for-each select="../App_Data[@Name = 'Category']">
				<xsl:call-template name="Category">
					<xsl:with-param name="catlist" select="@Value" />
				</xsl:call-template>
			</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="../App_Data[@Name = 'L2V_Category1']">
					<tns:Category>
						<tns:Text><xsl:value-of select="../App_Data[@Name = 'L2V_Category1']/@Value"/></tns:Text>
					</tns:Category>
				</xsl:if>
				<xsl:if test="../App_Data[@Name = 'L2V_Category2']">
					<tns:Category>
						<tns:Text><xsl:value-of select="../App_Data[@Name = 'L2V_Category2']/@Value"/></tns:Text>
					</tns:Category>
				</xsl:if>
				<xsl:if test="../App_Data[@Name = 'L2V_Category3']">
					<tns:Category>
						<tns:Text><xsl:value-of select="../App_Data[@Name = 'L2V_Category3']/@Value"/></tns:Text>
					</tns:Category>
				</xsl:if>
				<xsl:if test="../App_Data[@Name = 'L2V_Category4']">
					<tns:Category>
						<tns:Text><xsl:value-of select="../App_Data[@Name = 'L2V_Category4']/@Value"/></tns:Text>
					</tns:Category>
				</xsl:if>
				<xsl:if test="../App_Data[@Name = 'L2V_Category5']">
					<tns:Category>
						<tns:Text><xsl:value-of select="../App_Data[@Name = 'L2V_Category5']/@Value"/></tns:Text>
					</tns:Category>
				</xsl:if>
				<xsl:if test="../App_Data[@Name = 'L2V_Category6']">
					<tns:Category>
						<tns:Text><xsl:value-of select="../App_Data[@Name = 'L2V_Category6']/@Value"/></tns:Text>
					</tns:Category>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="../App_Data/@Name = 'Provider_QA_Contact'">
			<tns:ProviderQAContact>
				<tns:Value><xsl:value-of select="../App_Data[@Name = 'Provider_QA_Contact']/@Value" /></tns:Value>
			</tns:ProviderQAContact>
		</xsl:if>
	</xsl:template>

<!--
	THE WORLD IS NOT READY FOR THIS TO BE DONE THE RIGHT WAY!!!
	<xsl:template name="Category">
		<xsl:param name="catlist" />
		<xsl:variable name="cat" select="substring-before($catlist,'/')" />
		<xsl:choose>
			<xsl:when test="string-length($cat) > 0">
				<tns:Category>
					<tns:Text><xsl:value-of select="$cat"/></tns:Text>
					<xsl:call-template name="Category">
						<xsl:with-param name="catlist">
							<xsl:value-of select="substring-after($catlist,'/')"/>
						</xsl:with-param>
					</xsl:call-template>
				</tns:Category>
			</xsl:when>
			<xsl:otherwise>
				<tns:Category>
					<tns:Text><xsl:value-of select="$catlist"/></tns:Text>
				</tns:Category>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
-->
	<xsl:template name="Category">
		<xsl:param name="catlist" />
		<tns:Category>
			<tns:Text><xsl:value-of select="$catlist"/></tns:Text>
		</tns:Category>
	</xsl:template>

	<xsl:template match="*" />

</xsl:stylesheet>
