<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:output method="xml" indent="yes"/>

	<xsl:template match="rating" mode="rating_metadata">
		<xsl:element name="tns:Value">
			<xsl:attribute name="system">
				<xsl:value-of select="@rating_system"/>
			</xsl:attribute>
			<xsl:value-of select="@value"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="rating_metadata"/>
	<xsl:template match="review" mode="common_metadata">
		<xsl:element name="tns:Review">
			<xsl:element name="tns:Type">
				<xsl:value-of select="@type"/>
			</xsl:element>
			<xsl:if test="@author">
				<xsl:element name="tns:Author">
					<xsl:value-of select="@author"/>
				</xsl:element>
			</xsl:if>
			<xsl:if test="@language">
				<xsl:element name="tns:Language">
					<xsl:value-of select="@language"/>
				</xsl:element>
			</xsl:if>
			<xsl:if test="@url">
				<xsl:element name="tns:Url">
					<xsl:value-of select="@url"/>
				</xsl:element>
			</xsl:if>
			<xsl:element name="tns:Value">
				<xsl:value-of select="."/>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="common_metadata"/>
	<!-- copyright optional -->
	<xsl:template match="macrovisionLevel" mode="copyright_optional">
		<xsl:element name="tns:MacroVisionLevel">
			<xsl:value-of select="."/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="cgmsaLevel" mode="copyright_optional">
		<xsl:element name="tns:CGMSA">
			<xsl:choose>
				<xsl:when test=". = 'copyfreely'">0</xsl:when>
				<xsl:when test=". = 'copynomore'">1</xsl:when>
				<xsl:when test=". = 'copyonce'">2</xsl:when>
				<xsl:when test=". = 'copynever'">3</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="disableHDCP" mode="copyright_optional">
		<xsl:element name="tns:disableHDCP">
			<xsl:choose>
				<xsl:when test=". = '1'">true</xsl:when>
				<xsl:when test=". = '0'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="copyright_optional"/>
	<!-- end -->
</xsl:stylesheet>
