package com.tandbergtv.metadatamanager.specimpl.cl1_1;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.CustomField;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;

//Must ensure uniqueness of all spec specific ids on add and update.

public class CL1_1SpecHandler extends SingleTitleSpecHandler {

	private static final String ADI_ROOTELEMENT_NAME = "ADI";

	public CL1_1SpecHandler() {
		super();
		this.spec = Spec.CL1_1;
		this.rootElementName = ADI_ROOTELEMENT_NAME;
	}

	@Override
	public IIdentifier extractId(Asset asset) {
		CL1_1_Identifier id = new CL1_1_Identifier();

		// set search service
		id.setSearchService(getSearchService());

		// set mapping resource
		id.setMappingResourceUrl(getMappingResourceUrl());

		// extract the id values after getting the ttvxpaths for the id fields.
		Map<String, String> idXPaths = id.getTTVPaths();

		Map<String, String> idValues = new HashMap<String, String>();
		Iterator<Entry<String, String>> iter = idXPaths.entrySet().iterator();
		while (iter.hasNext()) {
			Entry<String, String> entry = iter.next();
			Field f = asset.getFirstField(entry.getValue());
			if (f != null) {
				idValues.put(entry.getKey(), f.getValue());
			}
		}

		// set these values in the id.
		id.setSpecIdentifiers(idValues);
		return id;
	}

	@Override
	public IdentifierBase getIdentifier() {
		CL1_1_Identifier identifier = new CL1_1_Identifier();
		identifier.setSearchService(searchService);
		identifier.setMappingResourceUrl(mappingResourceUrl);
		
		return identifier;
		
	}

	@Override
	protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
		boolean supperResult = super.isXPathPartOfSpec(assetType, ttvXPath);
		if(!supperResult && ttvXPath!= null && ttvXPath.contains(CustomField.CUSTOMFIELD)){
			return true;
		}else{
			return supperResult;
		}
	}
	
	
}