package com.tandbergtv.metadatamanager.specimpl.cl1_1;

import java.util.HashMap;
import java.util.Map;

import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;

/**
 * Keeping Cl1.1 and MSTV classes separate as the xpaths are different.
 * 
 * @author spuranik
 * 
 */
public class CL1_1_Identifier extends IdentifierBase {

	private static final long serialVersionUID = -8112844616094249184L;
	/* xpaths for spec specific identifiers */
	private static String PROVIDERID_XPATH = "ADI/Metadata/AMS/Provider_ID";
	private static String ASSETID_XPATH = "ADI/Metadata/AMS/Asset_ID";

	/* spec specific identifiers */
	private String providerId;
	private String assetId;

	/**
	 * @return the assetId
	 */
	public String getAssetId() {
		return assetId;
	}

	/**
	 * @return the providerId
	 */
	public String getProviderId() {
		return providerId;
	}

	public Map<String, String> getSpecIdentifiers() {
		Map<String, String> map = new HashMap<String, String>();
		map.put(PROVIDERID_XPATH, providerId);
		map.put(ASSETID_XPATH, assetId);
		return map;
	}

	public Map<String, String> getTTVPaths() {
		Map<String, String> ttvPaths = new HashMap<String, String>();

		String assetIdXpath = MappingFileParser.getMapping(
				getMappingResourceUrl(), ASSETID_XPATH);
		if (assetIdXpath.trim().length() == 0) {
			throw new RuntimeException("Identifying field: " + ASSETID_XPATH
					+ " cannot be mapped to TTV xpath.");
		}
		String providerIdXpath = MappingFileParser.getMapping(
				getMappingResourceUrl(), PROVIDERID_XPATH);
		if (providerIdXpath.trim().length() == 0) {
			throw new RuntimeException("Identifying field: " + PROVIDERID_XPATH
					+ " cannot be mapped to TTV xpath.");
		}

		ttvPaths.put(ASSETID_XPATH, assetIdXpath);
		ttvPaths.put(PROVIDERID_XPATH, providerIdXpath);
		return ttvPaths;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isValidIdentifier() {
		if (providerId != null && !providerId.equals("")) {
			if (assetId != null && !assetId.equals("")) {
				return true;
			}
		}
		return false;
	}

	/**
	 * @param assetId
	 *            the assetId to set
	 */
	public void setAssetId(String assetId) {
		this.assetId = assetId;
	}

	/**
	 * @param providerId
	 *            the providerId to set
	 */
	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}

	public void setSpecIdentifiers(Map<String, String> identifiers) {
		if (identifiers.containsKey(ASSETID_XPATH)) {
			setAssetId(identifiers.get(ASSETID_XPATH));
		}
		if (identifiers.containsKey(PROVIDERID_XPATH)) {
			setProviderId(identifiers.get(PROVIDERID_XPATH));
		}
	}

	@Override
	public boolean equals(Object o) {
		if(this == o)
			return true;
		
		if(!(o instanceof CL1_1_Identifier))
			return false;
		
		CL1_1_Identifier another = (CL1_1_Identifier) o;
		
		return (isEqual(providerId, another.providerId) &&
				isEqual(assetId, another.assetId));
	}
	
	private boolean isEqual(String s1, String s2) {
		return (s1 == null) ? s2 == null : s1.equals(s2);
	}
	
	@Override
	public int hashCode() {
		int h1 = (providerId != null) ? providerId.hashCode() : 0;
		int h2 = (assetId != null) ? assetId.hashCode() : 0;
				
		return (h1 + h2 + 7) * 13;
	}
	
	@Override
	public String toString() {
		return providerId + " | " + assetId ;
	}
}
