<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:import href="to/common.xsl"/>
	<xsl:output method="xml" indent="yes"/>

	<!-- Movie -->
	<xsl:template match="AMS" mode="movie">
		<xsl:for-each select="../App_Data[@Name = 'Audio_Type']">
			<xsl:call-template name="AudioType">
				<xsl:with-param name="typeList" select="@Value" />
			</xsl:call-template>
		</xsl:for-each>

		<xsl:apply-templates select="../*" mode="movie_optional"/>
		<xsl:apply-templates select="../*" mode="language_optional"/>
		<xsl:if test="../App_Data[@Name = 'Screen_Format'] or ../App_Data[@Name = 'HDContent'] or ../App_Data[@Name = 'Bit_Rate']">
			<xsl:element name="tns:Video">
				<xsl:apply-templates select="../*" mode="video_optional"/>
			</xsl:element>
		</xsl:if>
		<xsl:if test="../App_Data[@Name = 'Copy_Protection'] or ../App_Data[@Name = 'Copy_Protection_Verbose'] or ../App_Data[@Name = 'Analog_Protection_System'] or ../App_Data[@Name = 'Encryption_Mode_Indicator'] or ../App_Data[@Name = 'Constrained_Image_Trigger'] or ../App_Data[@Name = 'CGMS_A']">
			<xsl:element name="tns:Copyright">
				<xsl:apply-templates select="../*" mode="copyright_optional"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="App_Data[@Name = 'Profile']" mode="movie_optional">
		<xsl:element name="tns:Profile">
			<xsl:value-of select="@Value" />		
		</xsl:element>
	</xsl:template>

	<!-- movie_optional -->
	<xsl:template match="App_Data[@Name = 'Encryption']" mode="movie_optional">
		<xsl:element name="tns:Encryption">
			<xsl:element name="tns:Value">
				<xsl:choose>
					<xsl:when test="@Value = 'Y'">true</xsl:when>
					<xsl:when test="@Value = 'N'">false</xsl:when>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Viewing_Can_Be_Resumed']" mode="movie_optional">
		<xsl:element name="tns:Rights">
			<xsl:element name="tns:ViewingCanBeResumed">
				<xsl:choose>
					<xsl:when test="@Value = 'Y'">true</xsl:when>
					<xsl:when test="@Value = 'N'">false</xsl:when>
				</xsl:choose>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="movie_optional"/>

	<!-- copyright_optional -->
	<xsl:template match="App_Data[@Name = 'Copy_Protection']" mode="copyright_optional">
		<xsl:element name="tns:CopyProtection">
			<xsl:choose>
				<xsl:when test="@Value = 'Y'">true</xsl:when>
				<xsl:when test="@Value = 'N'">false</xsl:when>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Copy_Protection_Verbose']" mode="copyright_optional">
		<xsl:element name="tns:CopyProtectionVerbose">
			<xsl:choose>
				<xsl:when test="@Value = 'Y'">true</xsl:when>
				<xsl:when test="@Value = 'N'">false</xsl:when>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Analog_Protection_System']" mode="copyright_optional">
		<xsl:element name="tns:AnalogProtectionSystem">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Encryption_Mode_Indicator']" mode="copyright_optional">
		<xsl:element name="tns:EncryptionModeIndicator">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Constrained_Image_Trigger']" mode="copyright_optional">
		<xsl:element name="tns:ConstrainedImageTrigger">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'CGMS_A']" mode="copyright_optional">
		<xsl:element name="tns:CGMSA">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>

	<xsl:template match="*" mode="copyright_optional"/>


</xsl:stylesheet>
