/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.baton.action;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WorkflowProcess;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class InitializeContextAction
implements ActionHandler {
    private static final long serialVersionUID = 7758619443590596779L;
    private static final String TASK_ID = "taskId";
    private static final String PROFILER_ID = "profilerId";
    private static final String OLD_JOB_PRIORITY = "oldJobPriority";
    private static final String RESOURCE = "resource";
    private Logger logger = Logger.getLogger(InitializeContextAction.class);

    public void execute(ExecutionContext context) throws Exception {
        String profilerId;
        String oldJobPriority = (String)context.getVariable(OLD_JOB_PRIORITY);
        if (oldJobPriority == null || oldJobPriority.trim().equals("")) {
            WorkflowProcess process = (WorkflowProcess)context.getToken().getProcessInstance();
            context.setVariable(OLD_JOB_PRIORITY, (Object)process.getPriority().toString());
            process.setPriority(ProcessPriority.HIGHEST);
        }
        String systemAllocatedResourceVariable = "_allocated_resource_" + context.getToken().getId();
        String systemAllocatedResource = (String)context.getProcessInstance().getContextInstance().getTransientVariable(systemAllocatedResourceVariable);
        this.logger.debug((Object)("Allocated resource for work order [" + context.getToken().getId() + "] = " + systemAllocatedResource));
        if (systemAllocatedResource != null && !systemAllocatedResource.trim().equals("")) {
            context.setVariable(RESOURCE, (Object)systemAllocatedResource);
        }
        String resourceHostVariable = "_resource_host_" + context.getToken().getId();
        context.setVariable(resourceHostVariable, context.getVariable(RESOURCE));
        String taskId = (String)context.getVariable(TASK_ID);
        if (taskId == null) {
            context.setVariable(TASK_ID, (Object)"");
        }
        if ((profilerId = (String)context.getVariable(PROFILER_ID)) == null) {
            context.setVariable(PROFILER_ID, (Object)"");
        }
    }
}

