/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.custom.validation;

import com.tandbergtv.cms.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.custom.validation.FieldTreeHelper;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.cms.rules.customrules.CustomValidationRule;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class WriterNameValidation
implements CustomValidationRule {
    private static final String WRITER = "WRITER";
    private static final String DISPLAY_NAME = "/Fields/Sources/Source/Contact/DisplayName";

    public boolean evalulteCriteria(Map<String, Object> parameters, Title title) {
        List<FieldTree> fieldTrees = FieldTreeHelper.breakApartFieldTree(title.getAsset().getFieldTreeForXpath(Arrays.asList("PACKAGE", "TITLE"), FieldTreeHelper.SOURCE), FieldTreeHelper.SOURCE);
        int totalLength = 0;
        for (FieldTree source : fieldTrees) {
            List fields = source.depthFirstTraversal();
            boolean isWriter = false;
            String displayName = "";
            for (Field f : fields) {
                if (f.getTtvXPath().equals(DISPLAY_NAME)) {
                    displayName = f.getValue();
                    continue;
                }
                if (!f.getTtvXPath().equals(FieldTreeHelper.ROLE_NAME) || !f.getValue().equals(WRITER)) continue;
                isWriter = true;
            }
            if (!isWriter) continue;
            totalLength += displayName.length();
        }
        return totalLength > 1024;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("writerNameValidation", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

