<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn xs">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>

<!-- Extra fields from TSTV 3.2 spec -->
<xsl:template name="title_tstv" >

	<!-- Start Time -->
	<xsl:if test="tns:Fields/tns:TvId/tns:Showtime/tns:StartTimeInUtc">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Start_Time</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TvId/tns:Showtime/tns:StartTimeInUtc" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Contract ID -->
	<xsl:if test="tns:Fields/tns:Rights/tns:Contract/tns:Id/tns:Id">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Contract_ID</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:Rights/tns:Contract/tns:Id/tns:Id" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Recording Region  -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Place/tns:Region">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Recording_Region</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Place/tns:Region" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<xsl:if test="tns:Fields/tns:TSTV/tns:ChannelId">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Channel_ID</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:ChannelId" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:EndTime">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">End_Time</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:EndTime" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:RecordPriority">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Record_Priority</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:RecordPriority" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:ProgramName">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Program_Name</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:ProgramName" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:ProgramId">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Program_ID</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:ProgramId" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:Repeat">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Repeat</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case(tns:Fields/tns:TSTV/tns:Repeat) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:PlaybackWindows">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Playback_Windows</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:PlaybackWindows" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:MaxCopies">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Max_Copies</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:MaxCopies" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:DeleteTime">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Delete_Time</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:DeleteTime" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:RefCount">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Ref_Count</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:RefCount" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:CatalogEntry">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Catalog_Entry</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case(tns:Fields/tns:TSTV/tns:CatalogEntry) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:PurgeTime">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Purge_Time</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:PurgeTime" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:TSTV/tns:ContentType">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Content_Type</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TSTV/tns:ContentType" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

</xsl:template>

</xsl:stylesheet>
