<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" 
xmlns:xs="http://www.w3.org/2001/XMLSchema"
version="1.0">
	<xsl:output method="xml" indent="yes"/>

	<!-- language_optional -->
	<xsl:template match="App_Data[@Name = 'Languages']" mode="language_optional">
		<xsl:element name="tns:Language">
			<xsl:attribute name="value">
				<xsl:value-of select="@Value" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Subtitle_Languages']" mode="language_optional">
		<xsl:element name="tns:SubTitleLanguage">
			<xsl:attribute name="value">
				<xsl:value-of select="@Value" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Dubbed_Languages']" mode="language_optional">
		<xsl:element name="tns:DubbedLanguage">
			<xsl:attribute name="value">
				<xsl:value-of select="@Value" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="language_optional"/>

	<!-- video_optional -->
	<xsl:template match="App_Data[@Name = 'Screen_Format']" mode="video_optional">
		<xsl:element name="tns:ScreenFormat">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'HDContent']" mode="video_optional">
		<xsl:element name="tns:HDContent">
			<xsl:choose>
				<xsl:when test="@Value = 'Y'">true</xsl:when>
				<xsl:when test="@Value = 'N'">false</xsl:when>
				<xsl:otherwise><xsl:value-of select="@Value" /></xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Bit_Rate']" mode="video_optional">
		<xsl:variable name="x" select="@Value"/>
		<xsl:element name="tns:BitRate">
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="($x castable as xs:decimal)">
						<!--Use format-number to avoid scientific format-->
						<xsl:value-of select="format-number(1000*$x,'#')" />
					</xsl:when>
					<xsl:otherwise>							
						<xsl:value-of select="$x" />
					</xsl:otherwise>							
				</xsl:choose>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="video_optional"/>

	<xsl:template name="AudioType">
		<xsl:param name="typeList" />
		<tns:Audio>
			<tns:Type>
				<xsl:value-of select="$typeList" />
			</tns:Type>
		</tns:Audio>
	</xsl:template>
		
</xsl:stylesheet>
