/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content.action;

import com.ericsson.cms.categorymgmt.service.ICategoryManager;
import com.ericsson.cms.devices.content.CategoryMessageDispatcher;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class DisassociateTitleMessageDispatcher
extends CategoryMessageDispatcher {
    private static final String CATEGORY_TITLE_ID = "categoryTitleId";

    public DisassociateTitleMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    protected WorkflowMessage generateResponse(WorkflowMessage message) {
        try {
            this.validateRequired(message, CATEGORY_TITLE_ID);
        }
        catch (Exception e) {
            throw new RuntimeException("Title Id is required field.");
        }
        ICategoryManager service = (ICategoryManager)InjectionUtil.injectInstance((String)"cms/CategoryManager/local", ICategoryManager.class);
        String titleIdStr = this.getMessageParameter(message, CATEGORY_TITLE_ID);
        try {
            long titleId = Long.parseLong(titleIdStr);
            service.disassociateCategoryPackage(titleId);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Title Id must be a numeric value.");
        }
        catch (Exception e) {
            String msg = "Failed to disassociate category from title : " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        return response;
    }
}

