/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.ContentClassBuilder;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.util.ContentClassListParser;
import com.tandbergtv.content.contentclass.util.IContentClassListParserListener;
import com.tandbergtv.content.contentclass.util.SpecUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ContentClassConverterFile
implements IContentClassListParserListener {
    private static Logger logger = Logger.getLogger(ContentClassConverterFile.class);
    private String specPath;
    private String oldExportPath;
    private String newExportPath;
    private ContentClassJaxbService jaxbService;
    private Specification spec;
    private ContentClassBuilder ccBuilder;
    private BufferedWriter writer;

    public ContentClassConverterFile(String string, String string2, String string3) {
        this.specPath = string;
        this.oldExportPath = string2;
        this.newExportPath = string3;
        this.jaxbService = new ContentClassJaxbService();
    }

    public void run() throws Exception {
        String string;
        logger.info((Object)("Loading old spec from " + this.specPath));
        this.spec = SpecUtil.loadSpecification(this.specPath);
        this.ccBuilder = new ContentClassBuilder(this.spec);
        logger.info((Object)("Loading old export file from " + this.oldExportPath));
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.oldExportPath));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        this.writer = new BufferedWriter(new FileWriter(this.newExportPath));
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.writer.newLine();
        this.writer.write("<contentclass-list>");
        this.writer.newLine();
        logger.info((Object)"Start processing old content classes");
        ContentClassListParser contentClassListParser = new ContentClassListParser(stringBuilder, this);
        contentClassListParser.parse();
        this.writer.write("</contentclass-list>");
        this.writer.close();
        logger.info((Object)("Wrote new export file to " + this.newExportPath));
    }

    @Override
    public void onContentClass(String string) {
        Object object;
        ArrayList<ContentClassPartner> arrayList = new ArrayList<ContentClassPartner>();
        ContentClass contentClass = null;
        try {
            contentClass = this.jaxbService.unmarshalContentClassWithPartners(string, arrayList);
            if ("2.5".equals(contentClass.getVersion())) {
                logger.info((Object)("Skipping content class " + contentClass.getName() + ". It is already at version " + "2.5"));
                return;
            }
            logger.info((Object)("Processing content class " + contentClass.getName()));
        }
        catch (Exception exception) {
            logger.error((Object)"Could not parse xml", (Throwable)exception);
            logger.error((Object)string);
            return;
        }
        try {
            object = this.ccBuilder.convertMetadata(contentClass.getMetadata());
            contentClass.setMetadata((ContentClassMetadata)object);
        }
        catch (Exception exception) {
            logger.error((Object)"Could not convert content class", (Throwable)exception);
            return;
        }
        try {
            object = this.jaxbService.marshalContentClassWithPartners(contentClass, arrayList, false);
            int n = ((String)object).indexOf("<contentClass");
            if (n >= 0) {
                this.writer.write((String)object, n, ((String)object).length() - n);
                this.writer.newLine();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Could not save content class", (Throwable)exception);
            return;
        }
    }
}

