/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class PropertyConverter {
    private static Logger logger = Logger.getLogger(PropertyConverter.class);

    public void process(String string, String string2) throws Exception {
        Serializable serializable;
        File file;
        logger.info((Object)"Merging old properties...");
        File file2 = new File(string);
        String string3 = file2.getName();
        if (string2 == null) {
            file = new File(string3);
        } else {
            serializable = new File(string2);
            if (!serializable.exists()) {
                serializable.mkdirs();
            }
            file = new File((File)serializable, string3);
        }
        logger.info((Object)("Loading old properties from " + string));
        serializable = this.loadOldProperties(string);
        logger.info((Object)"done");
        Properties properties = this.loadDefaultProperties();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        treeMap.putAll(properties);
        treeMap.putAll((Map<Object, Object>)((Object)serializable));
        logger.info((Object)("Writing merged properties to " + file.getAbsolutePath()));
        this.writeProperties(treeMap, file);
        logger.info((Object)"done");
    }

    private void writeProperties(Map<Object, Object> map, File file) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("# Autogenerated");
        bufferedWriter.newLine();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            bufferedWriter.write(entry.getKey() + "=" + entry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    private Properties loadOldProperties(String string) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileReader(string));
        return properties;
    }

    private Properties loadDefaultProperties() throws Exception {
        logger.info((Object)"Loading default properties from a classpath");
        InputStream inputStream = PropertyConverter.class.getClassLoader().getResourceAsStream("ecmf.properties");
        if (inputStream == null) {
            throw new Exception("Could not load ecmf.properties template from a jar.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Properties properties = new Properties();
        properties.load(bufferedReader);
        logger.info((Object)"done");
        return properties;
    }
}

