/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass;

import com.tandbergtv.content.contentclass.CustomFieldDataTypeMappingHandler;
import com.tandbergtv.content.contentclass.CustomFieldHandler;
import com.tandbergtv.content.contentclass.PropertyConverter;
import com.tandbergtv.content.contentclass.SpecAttributeHandler;
import com.tandbergtv.content.contentclass.option.OptionsMerger;
import com.tandbergtv.content.contentclass.spec.FlatSpec;
import com.tandbergtv.content.contentclass.spec.FlatSpecBuilder;
import com.tandbergtv.content.contentclass.util.SpecUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationJaxbService;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.AutofillProviderType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SpecConverter {
    private static Logger logger = Logger.getLogger(SpecConverter.class);
    private static final String FILE_NAME_NEW_SPEC = "definition.xml";
    private static final String FILE_NAME_DATATYPE_MAPPING = "cfDataTypeMapping.dat";
    private String oldSpecPath;
    private String oldPropsPath;
    private String outputFolder;
    private Specification oldSpec;
    private FlatSpec oldFlatSpec;
    private Specification newSpec;

    public SpecConverter(String string, String string2, String string3) {
        this.oldSpecPath = string;
        this.oldPropsPath = string2;
        this.outputFolder = string3;
        if (string3 == null) {
            this.outputFolder = "./out";
        }
    }

    public void run() throws Exception {
        this.newSpec = SpecUtil.loadNewSpecificationTemplate();
        this.oldSpec = SpecUtil.loadSpecification(this.oldSpecPath);
        FlatSpecBuilder flatSpecBuilder = new FlatSpecBuilder(this.oldSpec);
        this.oldFlatSpec = flatSpecBuilder.build();
        this.mergeAttributes();
        this.mergeCustomFields();
        this.mergeOptions();
        this.mergeAutoFillProviders();
        this.writeSpec();
        this.createCustomFieldDataTypeMapping(this.newSpec);
        PropertyConverter propertyConverter = new PropertyConverter();
        propertyConverter.process(this.oldPropsPath, this.outputFolder);
    }

    void mergeAttributes() {
        logger.info((Object)"Merging attributes...");
        SpecAttributeHandler specAttributeHandler = new SpecAttributeHandler(this.oldFlatSpec, this.newSpec);
        specAttributeHandler.run();
        logger.info((Object)"Finished merging attributes.");
    }

    void mergeCustomFields() {
        logger.info((Object)"Merging custom fields...");
        CustomFieldHandler customFieldHandler = new CustomFieldHandler(this.oldSpec, this.newSpec);
        customFieldHandler.mergeCustomFields();
        logger.info((Object)"Finished merging custom fields.");
    }

    void mergeOptions() throws Exception {
        logger.info((Object)"Merging field options...");
        UISpecification uISpecification = SpecUtil.loadUISpecification(this.oldSpecPath);
        OptionsMerger optionsMerger = new OptionsMerger();
        optionsMerger.merge(uISpecification, this.newSpec);
        logger.info((Object)"Finished merging field options.");
    }

    private void writeSpec() throws Exception {
        String string = null;
        File file = new File(this.outputFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        string = new File(file, FILE_NAME_NEW_SPEC).getAbsolutePath();
        logger.info((Object)("Writing new spec to " + string));
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        specificationJaxbService.marshal(this.newSpec, string);
        logger.info((Object)"Finished writing new spec.");
    }

    private void mergeAutoFillProviders() {
        if (this.oldSpec.getAutofillProviders() == null) {
            return;
        }
        List<AutofillProviderType> list = this.oldSpec.getAutofillProviders().getProvider();
        if (list == null || list.isEmpty()) {
            return;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        List<AutofillProviderType> list2 = this.newSpec.getAutofillProviders().getProvider();
        for (AutofillProviderType object : list2) {
            treeMap.put(object.getName(), object.getJavaClass());
        }
        for (AutofillProviderType autofillProviderType : list) {
            treeMap.put(autofillProviderType.getName(), autofillProviderType.getJavaClass());
        }
        list2.clear();
        for (Map.Entry entry : treeMap.entrySet()) {
            AutofillProviderType autofillProviderType = new AutofillProviderType();
            autofillProviderType.setName((String)entry.getKey());
            autofillProviderType.setJavaClass((String)entry.getValue());
            list2.add(autofillProviderType);
        }
    }

    void createCustomFieldDataTypeMapping(Specification specification) throws Exception {
        logger.info((Object)"Creating custom field data type mapping...");
        CustomFieldDataTypeMappingHandler customFieldDataTypeMappingHandler = new CustomFieldDataTypeMappingHandler(specification);
        customFieldDataTypeMappingHandler.process();
        Map<String, String> map = customFieldDataTypeMappingHandler.getDataTypeMap();
        String string = null;
        File file = new File(this.outputFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        string = new File(file, FILE_NAME_DATATYPE_MAPPING).getAbsolutePath();
        logger.info((Object)("Writing custom field data type mapping to " + string));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            bufferedWriter.write(entry.getKey() + ", " + entry.getValue());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        logger.info((Object)"Finished creating custom field data type mapping");
    }
}

