/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.entities;

import com.tandbergtv.content.contentclass.entities.ContentClassField;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ContentClassAsset
implements Serializable {
    private static final long serialVersionUID = -2735527115040393561L;
    private String path;
    private boolean disabled;
    private int min = 1;
    private int max = 1;
    private int batchMin = 1;
    private int batchMax = 1;
    private boolean hideFileView;
    private boolean requiresFile;
    private Map<String, ContentClassField> fields = new HashMap<String, ContentClassField>();

    public ContentClassAsset(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public ContentClassField getField(String string) {
        if (this.fields == null) {
            return null;
        }
        return this.fields.get(string);
    }

    public Collection<ContentClassField> getFieldList() {
        if (this.fields == null || this.fields.isEmpty()) {
            return null;
        }
        return this.fields.values();
    }

    public void addField(ContentClassField contentClassField) {
        if (contentClassField == null) {
            return;
        }
        if (contentClassField.isEnabled() && contentClassField.getPath() != null) {
            String[] stringArray = contentClassField.getPath().split("/");
            StringBuilder stringBuilder = new StringBuilder("/Fields");
            for (int i = 2; i < stringArray.length - 1; ++i) {
                stringBuilder.append("/" + stringArray[i]);
                String string = stringBuilder.toString();
                if (this.fields.containsKey(string)) continue;
                this.fields.put(string, new ContentClassField(string));
            }
        }
        this.fields.put(contentClassField.getPath(), contentClassField);
    }

    public boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(Integer n) {
        this.min = n == null ? 1 : n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(Integer n) {
        this.max = n == null ? 1 : n;
    }

    public int getBatchMin() {
        return this.batchMin;
    }

    public void setBatchMin(Integer n) {
        if (n == null) {
            n = 1;
        } else {
            this.batchMin = n;
        }
    }

    public int getBatchMax() {
        return this.batchMax;
    }

    public void setBatchMax(Integer n) {
        if (n == null) {
            n = 1;
        } else {
            this.batchMax = n;
        }
    }

    public boolean isHideFileView() {
        return this.hideFileView;
    }

    public void setHideFileView(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.hideFileView = bl;
    }

    public boolean isRequiresFile() {
        return this.requiresFile;
    }

    public void setRequiresFile(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.requiresFile = bl;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean bl) {
        if (bl == null) {
            return;
        }
        this.disabled = bl;
    }
}

