/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.hibernate;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.hibernate.ContentClassEntity;
import com.tandbergtv.content.contentclass.hibernate.ContentClassHibernateFactory;
import com.tandbergtv.content.contentclass.hibernate.ContentClassPartnerEntity;
import com.tandbergtv.content.contentclass.jaxb.ContentClassJaxbService;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.TitlesAssociatedException;
import com.tandbergtv.content.contentclass.util.ContentClassMerger;
import com.tandbergtv.content.contentclass.util.HibernateContext;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.type.TimestampType;
import org.hibernate.type.Type;

public class ContentClassServiceHibernate {
    private static Logger logger = Logger.getLogger(ContentClassServiceHibernate.class);

    public Date getContentClassLastUpdateDate() throws ContentClassPersistenceException {
        String string = "select max(updatedate) as updatedate from PMM_CONTENT_CLASS";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery sQLQuery = session.createSQLQuery(string);
        sQLQuery.addScalar("updatedate", (Type)new TimestampType());
        Date date = (Date)sQLQuery.uniqueResult();
        return date;
    }

    public Map<String, Map<String, String>> getFieldsWithOptions() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            GetOptionsWork getOptionsWork = new GetOptionsWork();
            session.doWork((Work)getOptionsWork);
            return getOptionsWork.getFieldsWithOptions();
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public List<ContentClass> getAllContentClassesWithoutMetadata() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select id, typeId, name, description, specialUsageId, isDefault from ContentClassEntity where typeId = 0";
            Query query = session.createQuery(string);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            return this.createContentClassList(list);
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long l) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select c.id, c.typeId, c.name, c.description, c.specialUsageId, c.isDefault from ContentClassEntity c, ContentClassPartnerEntity p  where c.id = p.contentClassId and p.partnerId = ?";
            Query query = session.createQuery(string);
            query.setLong(0, l);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            return this.createContentClassList(list);
        }
        catch (Exception exception) {
            String string = "Unable to get a list of content classes";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    private List<ContentClass> createContentClassList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<ContentClass> arrayList = new ArrayList<ContentClass>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = (Object[])list.get(i);
            ContentClass contentClass = new ContentClass();
            contentClass.setId((Long)objectArray[0]);
            int n = (Integer)objectArray[1];
            switch (n) {
                case 0: {
                    contentClass.setType(ContentClass.Type.Package);
                    break;
                }
                case 1: {
                    contentClass.setType(ContentClass.Type.Series);
                    break;
                }
                case 2: {
                    contentClass.setType(ContentClass.Type.Category);
                    break;
                }
                default: {
                    contentClass.setType(ContentClass.Type.Package);
                }
            }
            contentClass.setName((String)objectArray[2]);
            contentClass.setDescription((String)objectArray[3]);
            int n2 = (Integer)objectArray[4];
            switch (n2) {
                case 1: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PreRoll);
                    break;
                }
                case 2: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.PostRoll);
                    break;
                }
                default: {
                    contentClass.setSpecialUsage(ContentClass.SpecialUsage.None);
                }
            }
            contentClass.setDefault((Boolean)objectArray[5]);
            arrayList.add(contentClass);
        }
        return arrayList;
    }

    public ContentClass getContentClassById(long l) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity contentClassEntity = (ContentClassEntity)session.get(ContentClassEntity.class, (Serializable)Long.valueOf(l));
            if (contentClassEntity == null) {
                String string = "Content class with id = " + l + " doesn't exist";
                throw new ContentClassPersistenceException(string);
            }
            return ContentClassHibernateFactory.createContentClass(contentClassEntity);
        }
        catch (Exception exception) {
            String string = "Unable to get a content classes with id = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void saveContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        if (contentClass == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassEntity contentClassEntity = ContentClassHibernateFactory.createContentClassHibernate(contentClass);
            session.saveOrUpdate((Object)contentClassEntity);
            contentClass.setId(contentClassEntity.id);
        }
        catch (Exception exception) {
            String string = "Unable to save a content classes with id = " + contentClass.getId();
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void deleteContentClassById(long l) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery("delete from pmm_content_class where id = ?");
            sQLQuery.setLong(0, l);
            sQLQuery.executeUpdate();
        }
        catch (Exception exception) {
            String string = "Unable to delete a content class with id = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public ContentClassPartner getContentClassPartner(long l, long l2, boolean bl) throws ContentClassPersistenceException {
        try {
            ContentClassPartner contentClassPartner = null;
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity contentClassPartnerEntity = new ContentClassPartnerEntity(l, l2);
            contentClassPartnerEntity = (ContentClassPartnerEntity)session.get(ContentClassPartnerEntity.class, (Serializable)contentClassPartnerEntity);
            if (contentClassPartnerEntity == null) {
                if (bl) {
                    throw new ContentClassPersistenceException("Content class " + l + " and partner " + l2 + " are not associated.");
                }
                contentClassPartner = new ContentClassPartner(l, l2);
            } else {
                contentClassPartner = ContentClassHibernateFactory.createContentClassPartner(contentClassPartnerEntity);
            }
            String string = "select cc.name as className,  p.name as partnerName, p.providerid from pmm_content_class cc, pmm_partner p where cc.id = ? and p.id_ = ?";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            sQLQuery.setLong(1, l2);
            Object[] objectArray = (Object[])sQLQuery.uniqueResult();
            if (objectArray == null) {
                throw new ContentClassPersistenceException("Invalid content class " + l + " or partner " + l2);
            }
            contentClassPartner.setContentClassName((String)objectArray[0]);
            contentClassPartner.setPartnerName((String)objectArray[1]);
            contentClassPartner.setProviderId((String)objectArray[2]);
            return contentClassPartner;
        }
        catch (ContentClassPersistenceException contentClassPersistenceException) {
            throw contentClassPersistenceException;
        }
        catch (Exception exception) {
            String string = "Unable to get content class partner with contentClassId = " + l + "and partnerId = " + l2;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void saveContentClassPartner(ContentClassPartner contentClassPartner) throws ContentClassPersistenceException {
        if (contentClassPartner == null) {
            return;
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            ContentClassPartnerEntity contentClassPartnerEntity = ContentClassHibernateFactory.createContentClassPartnerEntity(contentClassPartner);
            session.saveOrUpdate((Object)contentClassPartnerEntity);
        }
        catch (Exception exception) {
            String string = "Unable to save a content class partner with contentClassId = " + contentClassPartner.getContentClassId() + "and partnerId = " + contentClassPartner.getPartnerId();
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public void deleteContentClassPartner(ContentClassPartner contentClassPartner) throws ContentClassPersistenceException {
        Object object;
        String string;
        if (contentClassPartner == null) {
            return;
        }
        boolean bl = false;
        try {
            string = "select id_ from pmm_title where content_class_id = ? and partner_id = ? and titlestatusid <> 5";
            object = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = object.createSQLQuery(string);
            sQLQuery.setLong(0, contentClassPartner.getContentClassId());
            sQLQuery.setLong(1, contentClassPartner.getPartnerId());
            sQLQuery.addScalar("id_", (Type)Hibernate.LONG);
            sQLQuery.setMaxResults(1);
            bl = sQLQuery.uniqueResult() != null;
        }
        catch (Exception exception) {
            String string2 = "Unable to check if there are titles created with content class [" + contentClassPartner.getContentClassId() + "] for partner [" + contentClassPartner.getPartnerId() + "]";
            logger.error((Object)string2, (Throwable)exception);
            throw new ContentClassPersistenceException(string2, exception);
        }
        if (bl) {
            throw new TitlesAssociatedException("There are titles in the system created with content class [" + contentClassPartner.getContentClassId() + "] for partner [" + contentClassPartner.getPartnerId() + "]");
        }
        try {
            string = HibernateContext.getContext().getCurrentSession();
            object = new ContentClassPartnerEntity(contentClassPartner.getContentClassId(), contentClassPartner.getPartnerId());
            string.delete(object);
        }
        catch (Exception exception) {
            object = "Unable to delete a content class partner with contentClassId = " + contentClassPartner.getContentClassId() + "and partnerId = " + contentClassPartner.getPartnerId();
            logger.error(object, (Throwable)exception);
            throw new ContentClassPersistenceException((String)object, exception);
        }
    }

    private boolean isSelfPartner(String string) throws Exception {
        String string2 = "select count(*) as cnt from pmm_partner p, pmm_partner_users u where p.id_ = u.partner_id and p.isactive = 1 and p.partnertype = 0 and u.username = ?";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery sQLQuery = session.createSQLQuery(string2);
        sQLQuery.setString(0, string);
        sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
        int n = (Integer)sQLQuery.uniqueResult();
        return n > 0;
    }

    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String string) throws ContentClassPersistenceException {
        return this.getContentClassPartnerMap(string, false);
    }

    public Map<Long, ContentClassPartnerList> getCategoryContentClassPartnerMap(String string) throws ContentClassPersistenceException {
        return this.getContentClassPartnerMap(string, true);
    }

    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String string, boolean bl) throws ContentClassPersistenceException {
        HashMap<Long, ContentClassPartnerList> hashMap = new HashMap<Long, ContentClassPartnerList>();
        try {
            SQLQuery sQLQuery;
            String string2;
            Session session = HibernateContext.getContext().getCurrentSession();
            if (this.isSelfPartner(string)) {
                string2 = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.isactive = 1";
                if (bl) {
                    string2 = string2 + " and c.content_class_type_id = 2";
                }
                sQLQuery = session.createSQLQuery(string2);
            } else {
                string2 = "select p.id_ as pid, p.name as pname, c.id as cid, c.name as cname, c.content_class_type_id as ctype from pmm_partner p, pmm_content_class c, pmm_content_class_partner cp, pmm_partner_users u where p.id_ = cp.partner_id and c.id = cp.content_class_id and p.id_ = u.partner_id and p.isactive = 1 and u.username = ?";
                if (bl) {
                    string2 = string2 + " and c.content_class_type_id = 2";
                }
                sQLQuery = session.createSQLQuery(string2);
                sQLQuery.setString(0, string);
            }
            sQLQuery.addScalar("pid", (Type)Hibernate.LONG);
            sQLQuery.addScalar("pname", (Type)Hibernate.STRING);
            sQLQuery.addScalar("cid", (Type)Hibernate.LONG);
            sQLQuery.addScalar("cname", (Type)Hibernate.STRING);
            sQLQuery.addScalar("ctype", (Type)Hibernate.INTEGER);
            List list = sQLQuery.list();
            if (list != null && !list.isEmpty()) {
                for (Object e : list) {
                    Object[] objectArray = (Object[])e;
                    Long l = (Long)objectArray[0];
                    String string3 = (String)objectArray[1];
                    Long l2 = (Long)objectArray[2];
                    String string4 = (String)objectArray[3];
                    Integer n = (Integer)objectArray[4];
                    ContentClassPartnerList contentClassPartnerList = (ContentClassPartnerList)hashMap.get(l);
                    if (contentClassPartnerList == null) {
                        contentClassPartnerList = new ContentClassPartnerList(l);
                        contentClassPartnerList.setPartnerName(string3);
                        hashMap.put(l, contentClassPartnerList);
                    }
                    contentClassPartnerList.addContentClass(l2, string4, n);
                }
            }
        }
        catch (Exception exception) {
            String string5 = "Unable to get content class partner map";
            logger.error((Object)string5, (Throwable)exception);
            throw new ContentClassPersistenceException(string5, exception);
        }
        return hashMap;
    }

    public Long getContentClassIdByName(String string) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string2 = "select id from ContentClassEntity where name = ?";
            Query query = session.createQuery(string2);
            query.setString(0, string);
            return (Long)query.uniqueResult();
        }
        catch (Exception exception) {
            String string3 = "Unable to get content class id by name " + string;
            logger.error((Object)string3, (Throwable)exception);
            throw new ContentClassPersistenceException(string3, exception);
        }
    }

    public Long getDefaultContentClassId() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select id from ContentClassEntity where isDefault = 1";
            Query query = session.createQuery(string);
            return (Long)query.uniqueResult();
        }
        catch (Exception exception) {
            String string = "Unable to get default content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public Long getCategoryContentClassId() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select id from ContentClassEntity where typeId = 2";
            Query query = session.createQuery(string);
            return (Long)query.uniqueResult();
        }
        catch (Exception exception) {
            String string = "Unable to get category content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public Long getSeriesContentClassId() throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = "select id from ContentClassEntity where typeId = 1";
            Query query = session.createQuery(string);
            return (Long)query.uniqueResult();
        }
        catch (Exception exception) {
            String string = "Unable to get category content class";
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public ContentClassPartner getMergedContentClassPartnerMetadataForIngest(long l, long l2) throws ContentClassPersistenceException {
        ContentClass contentClass = this.getContentClassById(l);
        if (contentClass == null) {
            throw new ContentClassPersistenceException("Content class with id " + l + " doesn't exist.");
        }
        ContentClassPartner contentClassPartner = this.getContentClassPartner(l, l2, true);
        if (contentClassPartner == null) {
            throw new ContentClassPersistenceException("Unable to get content class partner: partnerId = " + l2 + ", contentClassId = " + l);
        }
        contentClassPartner.setContentClassType(contentClass.getType());
        ContentClassMerger contentClassMerger = new ContentClassMerger();
        ContentClassMetadata contentClassMetadata = contentClassMerger.mergeMetadata(contentClass.getMetadata(), contentClassPartner.getMetadata());
        contentClassPartner.setMetadata(contentClassMetadata);
        return contentClassPartner;
    }

    public ContentClassPartner getMergedContentClassPartnerMetadataForView(long l, long l2) throws ContentClassPersistenceException {
        ContentClass contentClass = this.getContentClassById(l);
        if (contentClass == null) {
            throw new ContentClassPersistenceException("Content class with id " + l + " doesn't exist.");
        }
        ContentClassPartner contentClassPartner = null;
        contentClassPartner = this.getContentClassPartner(l, l2, false);
        if (contentClassPartner == null) {
            throw new ContentClassPersistenceException("Unable to get content class partner: partnerId = " + l2 + ", contentClassId = " + l);
        }
        contentClassPartner.setContentClassType(contentClass.getType());
        ContentClassMerger contentClassMerger = new ContentClassMerger();
        ContentClassMetadata contentClassMetadata = contentClassMerger.mergeMetadata(contentClass.getMetadata(), contentClassPartner.getMetadata());
        contentClassPartner.setMetadata(contentClassMetadata);
        return contentClassPartner;
    }

    public void deleteContentClassesById(Collection<Long> collection) throws ContentClassPersistenceException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        long l = 0L;
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery("delete from pmm_content_class where id = ?");
            for (Long l2 : collection) {
                l = l2;
                sQLQuery.setLong(0, l2.longValue());
                sQLQuery.executeUpdate();
            }
        }
        catch (Exception exception) {
            String string = "Unable to delete a content class with id = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public boolean contentClassNameExists(String string) throws ContentClassPersistenceException {
        String string2 = "select count(*) as cnt from pmm_content_class where name = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery(string2);
            sQLQuery.setString(0, string);
            sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer n = (Integer)sQLQuery.uniqueResult();
            return n > 0;
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to check if content class name exists", (Throwable)exception);
            throw new ContentClassPersistenceException(exception);
        }
    }

    public boolean contentClassAssociatedWithTitle(long l) throws ContentClassPersistenceException {
        String string = "select count(*) as cnt from pmm_title where content_class_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer n = (Integer)sQLQuery.uniqueResult();
            return n > 0;
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to check if a content class is associated with titles", (Throwable)exception);
            throw new ContentClassPersistenceException(exception);
        }
    }

    public boolean contentClassPartnerExists(long l, long l2) throws ContentClassPersistenceException {
        String string = "select count(*) as cnt from pmm_content_class_partner where content_class_id = ? and partner_id = ?";
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            sQLQuery.setLong(1, l2);
            sQLQuery.addScalar("cnt", (Type)Hibernate.INTEGER);
            Integer n = (Integer)sQLQuery.uniqueResult();
            return n > 0;
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to check if a content class partner exists", (Throwable)exception);
            throw new ContentClassPersistenceException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContentClassPartner> getContentClassPartnersByContentClassId(long l, boolean bl) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string = bl ? "select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid, ccp.data from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?" : "select cc.name as cname, p.id_ as pid, p.name as pname, p.providerid from pmm_content_class_partner ccp, pmm_partner p, pmm_content_class cc where ccp.content_class_id = cc.id and ccp.partner_id = p.id_ and ccp.content_class_id = ?";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.setLong(0, l);
            List list = sQLQuery.list();
            if (list == null || list.isEmpty()) {
                return null;
            }
            ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
            ArrayList<ContentClassPartner> arrayList = new ArrayList<ContentClassPartner>();
            for (Object e : list) {
                Clob clob;
                Object[] objectArray = (Object[])e;
                ContentClassPartner contentClassPartner = new ContentClassPartner();
                contentClassPartner.setContentClassId(l);
                contentClassPartner.setContentClassName((String)objectArray[0]);
                BigDecimal bigDecimal = (BigDecimal)objectArray[1];
                if (bigDecimal != null) {
                    contentClassPartner.setPartnerId(bigDecimal.longValue());
                }
                contentClassPartner.setPartnerName((String)objectArray[2]);
                contentClassPartner.setProviderId((String)objectArray[3]);
                if (bl && (clob = (Clob)objectArray[4]) != null) {
                    Reader reader = clob.getCharacterStream();
                    try {
                        ContentClassMetadata contentClassMetadata = contentClassJaxbService.unmarshalContentClassMetadata(reader);
                        contentClassPartner.setMetadata(contentClassMetadata);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                arrayList.add(contentClassPartner);
            }
            return arrayList;
        }
        catch (Exception exception) {
            String string = "Unable to get content class partners with contentClassId = " + l;
            logger.error((Object)string, (Throwable)exception);
            throw new ContentClassPersistenceException(string, exception);
        }
    }

    public String marshalContentClass(ContentClass contentClass) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.marshalContentClass(contentClass, false);
    }

    public ContentClass unmarshalContentClass(String string) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.unmarshalContentClass(string);
    }

    public String marshalContentClassWithPartners(ContentClass contentClass, List<ContentClassPartner> list) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.marshalContentClassWithPartners(contentClass, list, false);
    }

    public ContentClass unmarshalContentClassWithPartners(String string, List<ContentClassPartner> list) throws ContentClassPersistenceException {
        ContentClassJaxbService contentClassJaxbService = new ContentClassJaxbService();
        return contentClassJaxbService.unmarshalContentClassWithPartners(string, list);
    }

    public Long getPartnerIdByName(String string) throws ContentClassPersistenceException {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            String string2 = "select id_ as id from pmm_partner where name = ? and isactive = 1";
            SQLQuery sQLQuery = session.createSQLQuery(string2);
            sQLQuery.addScalar("id", (Type)Hibernate.LONG);
            sQLQuery.setString(0, string);
            return (Long)sQLQuery.uniqueResult();
        }
        catch (Exception exception) {
            String string3 = "Unable to get partner id by name " + string;
            logger.error((Object)string3, (Throwable)exception);
            throw new ContentClassPersistenceException(string3, exception);
        }
    }

    private static class GetOptionsWork
    implements Work {
        private Map<String, Map<String, String>> fieldsMap = new HashMap<String, Map<String, String>>();

        public void execute(Connection connection) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select data from pmm_content_class");
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    try {
                        if (string == null) continue;
                        ContentClassMetadata contentClassMetadata = ContentClassHibernateFactory.parseMetadata(string);
                        this.processContentClass(contentClassMetadata);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public Map<String, Map<String, String>> getFieldsWithOptions() {
            return this.fieldsMap;
        }

        private void processContentClass(ContentClassMetadata contentClassMetadata) {
            if (contentClassMetadata == null) {
                return;
            }
            Collection<ContentClassAsset> collection = contentClassMetadata.getAssetList();
            if (collection != null) {
                for (ContentClassAsset contentClassAsset : collection) {
                    Collection<ContentClassField> collection2 = contentClassAsset.getFieldList();
                    if (collection2 == null) continue;
                    for (ContentClassField contentClassField : collection2) {
                        List<ContentClassOption> list = contentClassField.getOptions();
                        if (list == null || list.isEmpty()) continue;
                        String string = contentClassField.getPath();
                        Map<String, String> map = this.fieldsMap.get(string);
                        if (map == null) {
                            map = new HashMap<String, String>();
                            this.fieldsMap.put(string, map);
                        }
                        for (ContentClassOption contentClassOption : list) {
                            String string2 = contentClassOption.getValue();
                            if (map.containsKey(string2)) continue;
                            map.put(string2, contentClassOption.getDisplayName());
                        }
                    }
                }
            }
        }
    }
}

