/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.util;

import com.tandbergtv.content.contentclass.util.HibernateContextException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public final class HibernateContext {
    private static HibernateContext context = new HibernateContext();
    private SessionFactory sessionFactory;
    private boolean active = false;

    private HibernateContext() {
    }

    private void initialize() {
        if (this.active) {
            return;
        }
        try {
            this.initializeSessionFactory();
        }
        catch (HibernateContextException hibernateContextException) {
            throw hibernateContextException;
        }
        catch (Exception exception) {
            String string = "Failed to load the Hibernate Context";
            throw new HibernateContextException(string, exception);
        }
        this.active = true;
    }

    private void initializeSessionFactory() {
        this.sessionFactory = new Configuration().configure().buildSessionFactory();
    }

    public static synchronized HibernateContext getContext() {
        if (context == null) {
            context = new HibernateContext();
        }
        return context;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (!this.active) {
            String string = "The Hibernate Context is not initialized, cannot get the SessionFactory.";
            throw new IllegalStateException(string);
        }
        return this.sessionFactory;
    }

    public Session getCurrentSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    public void beginTransaction() {
        this.getCurrentSession().beginTransaction();
    }

    public void commitTransaction() {
        this.getCurrentSession().getTransaction().commit();
    }

    public void rollbackTransaction() {
        this.getCurrentSession().getTransaction().rollback();
    }

    public Session openSession() {
        return this.getSessionFactory().openSession();
    }

    public synchronized void initializeContext() {
        this.initialize();
    }

    public synchronized void closeContext() {
        if (!this.active) {
            return;
        }
        try {
            if (this.sessionFactory != null) {
                this.sessionFactory.close();
            }
        }
        catch (Exception exception) {
            String string = "Failed to close the Hibernate Context.";
            throw new HibernateContextException(string, exception);
        }
        finally {
            this.sessionFactory = null;
            this.active = false;
        }
    }

    public boolean isActive() {
        return this.isActive();
    }
}

