/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.util;

import com.tandbergtv.content.contentclass.util.SpecSearchHelper;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationJaxbService;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationReader;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.TitleType;
import com.tandbergtv.watchpoint.pmm.title.conf.jaxb.VariableType;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpecUtil {
    private static Logger logger = Logger.getLogger(SpecUtil.class);

    private SpecUtil() {
    }

    public static void loadDataTypeMappingTemplate(Map<String, String> map) throws Exception {
        String string;
        String string2 = "cfDataTypeMapping.dat";
        logger.info((Object)"Loading default cfDataTypeMapping.dat...");
        InputStream inputStream = SpecUtil.class.getClassLoader().getResourceAsStream(string2);
        if (inputStream == null) {
            throw new Exception("Could not find " + string2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#") || string.indexOf(",") == -1) continue;
            String[] stringArray = string.split(",");
            String string3 = stringArray[0].trim();
            String string4 = stringArray[1].trim();
            map.put(string3, string4);
        }
        bufferedReader.close();
        logger.info((Object)"Loaded data type mapping.");
    }

    public static Specification loadSpecification(String string) throws Exception {
        logger.info((Object)("Loading specification from " + string));
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        Specification specification = specificationJaxbService.unmarshal(string);
        logger.info((Object)"Loaded spec.");
        return specification;
    }

    public static Specification loadNewSpecificationTemplate() throws Exception {
        String string = "definition.xml";
        logger.info((Object)"Loading new spec template from a jar...");
        InputStream inputStream = SpecUtil.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new Exception("Could not find " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        SpecificationJaxbService specificationJaxbService = new SpecificationJaxbService();
        Specification specification = specificationJaxbService.unmarshal(bufferedReader);
        logger.info((Object)"Loaded spec.");
        return specification;
    }

    public static UISpecification loadUISpecification(String string) throws Exception {
        logger.info((Object)("Loading UI Spec from " + string));
        SpecificationReader specificationReader = new SpecificationReader();
        UISpecification uISpecification = specificationReader.unmarshal(string, null, null);
        logger.info((Object)"Loaded UI spec.");
        return uISpecification;
    }

    public static VariableType findCustomFieldsVariable(TitleType titleType) {
        if (titleType == null) {
            return null;
        }
        List<VariableType> list = titleType.getMetadata().getVariable();
        for (VariableType variableType : list) {
            if (!"CustomFields".equals(variableType.getName())) continue;
            return variableType;
        }
        return null;
    }

    public static void addCustomFieldsVariable(TitleType titleType, VariableType variableType) {
        List<VariableType> list = titleType.getMetadata().getVariable();
        list.add(variableType);
    }

    public static TitleType findTitleByPath(Specification specification, String string) {
        SpecSearchHelper specSearchHelper = new SpecSearchHelper();
        return specSearchHelper.findTitle(specification, string);
    }
}

