/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms;

import com.ericsson.cms.MergeMapReader;
import com.ericsson.cms.PartnerManager;
import com.ericsson.cms.Scheduler;
import com.ericsson.cms.SiteManager;
import com.ericsson.cms.Util;
import com.ericsson.cms.hibernate.HibernateUtil;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] stringArray) {
        try {
            Main.upgrade();
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgrade() {
        Map<Long, Integer> map;
        Date date = new Date();
        logger.info((Object)("Upgrade started at: " + date));
        Date date2 = Main.getBeginningOfTomorrow(date);
        logger.info((Object)("All pitch schedules with pitch date before " + date2 + " will be ignored from scheduling"));
        File file = new File("../resources/merge.info");
        if (file.exists()) {
            try {
                map = MergeMapReader.getMergeMap(file);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error in getting merge information from file: " + file, iOException);
            }
        } else {
            logger.info((Object)("Merge information file not found at: " + file + ". Assumed to not merge"));
            map = new HashMap<Long, Integer>();
        }
        try {
            Serializable serializable;
            Main.getSession().beginTransaction();
            Scheduler.start();
            if (Util.hasFinishRecord()) {
                logger.info((Object)"Finish record found. Aborting.");
                return;
            }
            for (Map.Entry<Long, Integer> iterator : map.entrySet()) {
                long logicalSite = iterator.getKey();
                int n = iterator.getValue();
                if (!PartnerManager.isDistPartnerExistWithId(logicalSite)) {
                    throw new RuntimeException("No distribution partner exists with id: " + logicalSite);
                }
                if (SiteManager.isDistSiteExistWithId(n)) continue;
                throw new RuntimeException("No distribution site exists with id: " + n);
            }
            logger.info((Object)"Cleaning up quartz jobs");
            Scheduler.cleanupQuartz();
            HashSet hashSet = new HashSet();
            for (Partner partner : PartnerManager.getDistPartners()) {
                Object object;
                Object object2;
                logger.info((Object)("Upgrading distribution partner: [" + partner.getId() + " | " + partner.getName() + "]"));
                Scheduler.deleteSchedulesOfDistPartner(partner.getId());
                serializable = map.get(partner.getId());
                if (serializable == null) {
                    object2 = new DistributionSite();
                    object = SiteManager.findNonExistingSiteName(partner.getName());
                    ((Site)object2).setName((String)object);
                    ((DistributionSite)object2).setDistributionOption(DistributionOption.IMMEDIATE);
                    Main.getSession().save(object2);
                    hashSet.add(((Site)object2).getId());
                    partner.setName("SITE_" + ((Site)object2).getId());
                    Main.save(partner);
                    logger.info((Object)("Merged with a new site: [" + object2 + "]"));
                } else {
                    object2 = SiteManager.inactivateDistSite((Integer)serializable);
                    partner.setName("SITE_" + serializable);
                    Main.save(partner);
                    logger.info((Object)("Merged with existing site: [" + object2 + "]"));
                }
                object2 = PartnerManager.getSchedules(partner.getContainerContextId());
                logger.info((Object)("There are " + object2.size() + " pitch schedules for this partner"));
                object = object2.iterator();
                while (object.hasNext()) {
                    DistributionSchedule distributionSchedule = (DistributionSchedule)object.next();
                    if (distributionSchedule.getPitchDate().before(date2)) {
                        logger.info((Object)("Ignored scheduling a job for pitch schedule: " + distributionSchedule.getId() + ". Reason: Pitch Time [" + distributionSchedule.getPitchDate() + "] is before tomorrow"));
                        continue;
                    }
                    Scheduler.schedule(distributionSchedule.getId(), distributionSchedule.getPitchDate());
                }
            }
            for (DistributionSite distributionSite : SiteManager.getDistSites()) {
                if (map.values().contains(distributionSite.getId()) || hashSet.contains(distributionSite.getId())) continue;
                serializable = PartnerManager.createDistPartner(distributionSite.getId());
                logger.info((Object)("Created a new partner: [" + ((Partner)serializable).getId() + " | " + ((Partner)serializable).getName() + "] for site: [" + distributionSite + "]"));
            }
            for (LogicalSite logicalSite : SiteManager.getLogicalSites()) {
                serializable = PartnerManager.createDistPartner(logicalSite.getId());
                logger.info((Object)("Created a new partner: [" + ((Partner)serializable).getId() + " | " + ((Partner)serializable).getName() + "] for site: [" + logicalSite + "]"));
            }
            Util.addFinishRecord();
            Main.getSession().getTransaction().commit();
        }
        finally {
            Scheduler.stop();
        }
        logger.info((Object)("Finished upgrading at: " + new Date()));
    }

    private static void save(Object object) {
        Main.getSession().save(object);
    }

    private static Date getBeginningOfTomorrow(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static Session getSession() {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }
}

