/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms;

import com.ericsson.cms.hibernate.HibernateUtil;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContact;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class PartnerManager {
    public static List<Partner> getDistPartners() {
        Query query = PartnerManager.getSession().createQuery("from Partner where isActive = true and type = ?");
        query.setParameter(0, (Object)PartnerType.DISTRIBUTION);
        List list = query.list();
        return list == null ? new ArrayList(0) : list;
    }

    public static Partner getDistPartner(long l) {
        Query query = PartnerManager.getSession().createQuery("from Partner where isActive = true and type = ? and id = ?");
        query.setParameter(0, (Object)PartnerType.DISTRIBUTION);
        query.setLong(1, l);
        return (Partner)query.uniqueResult();
    }

    public static boolean isDistPartnerExistWithId(long l) {
        return PartnerManager.getDistPartner(l) != null;
    }

    public List<DistributionSchedule> getFutureSchedules(long l, Date date) {
        ArrayList<DistributionSchedule> arrayList = new ArrayList<DistributionSchedule>();
        for (DistributionSchedule distributionSchedule : PartnerManager.getSchedules(l)) {
            if (distributionSchedule.getDate().before(date)) continue;
            arrayList.add(distributionSchedule);
        }
        return arrayList;
    }

    public static List<DistributionSchedule> getSchedules(long l) {
        Query query = PartnerManager.getSession().createQuery("from DistributionSchedule where isActive = true and contextID = ?");
        query.setLong(0, l);
        List list = query.list();
        return list == null ? new ArrayList(0) : list;
    }

    public static Partner createDistPartner(int n) {
        Partner partner = new Partner();
        partner.setType(PartnerType.DISTRIBUTION);
        partner.setName("SITE_" + n);
        PartnerContact partnerContact = new PartnerContact();
        partnerContact.setPartner(partner);
        partner.setContact(partnerContact);
        partner.setIsActive(true);
        PartnerManager.getSession().save((Object)partner);
        return partner;
    }

    private static Session getSession() {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }
}

