/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.TrackingSite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributionSite
extends Site {
    private static final long serialVersionUID = -6462042194756033513L;
    private String metadataFormat;
    private String commaSeparatedFileLookupKeys;
    private DistributionOption distributionOption;
    private Integer alertDelayPeriod;
    private String distTemplateName;
    private Map<String, String> distConfParams;
    private String exportPluginName;
    private Map<String, String> exportConfParams;
    private Long associatedResourceId;
    private LogicalSite parent;
    private Set<TrackingSite> children;

    public void setChildren(Set<TrackingSite> set) {
        this.children = set;
    }

    public void addChild(TrackingSite trackingSite) {
        if (this.children == null) {
            this.children = new HashSet<TrackingSite>();
        }
        this.children.add(trackingSite);
    }

    public boolean removeChild(TrackingSite trackingSite) {
        if (this.children != null) {
            return this.children.remove(trackingSite);
        }
        return false;
    }

    public void clearChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public Set<TrackingSite> getChildren() {
        return this.children;
    }

    @Override
    public Set<Site> getSiteChildren() {
        HashSet<Site> hashSet = new HashSet<Site>();
        if (this.children != null) {
            for (TrackingSite trackingSite : this.children) {
                hashSet.add(trackingSite);
            }
        }
        return hashSet;
    }

    public void setParent(LogicalSite logicalSite) {
        this.parent = logicalSite;
    }

    public LogicalSite getParent() {
        return this.parent;
    }

    @Override
    public SiteType getType() {
        return SiteType.DISTRIBUTION;
    }

    @Override
    public Set<Site> getSiteParents() {
        HashSet<Site> hashSet = new HashSet<Site>();
        if (this.parent != null) {
            hashSet.add(this.parent);
        }
        return hashSet;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public void setMetadataFormat(String string) {
        this.metadataFormat = string;
    }

    public List<String> getFileLookupKeys() {
        if (this.commaSeparatedFileLookupKeys == null || this.commaSeparatedFileLookupKeys.isEmpty()) {
            return null;
        }
        String[] stringArray = this.commaSeparatedFileLookupKeys.split(",");
        return Arrays.asList(stringArray);
    }

    public void setFileLookupKeys(List<String> list) {
        if (list == null || list.isEmpty()) {
            this.commaSeparatedFileLookupKeys = null;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
        }
        this.commaSeparatedFileLookupKeys = stringBuffer.toString();
    }

    protected String getCommaSeparatedFileLookupKeys() {
        return this.commaSeparatedFileLookupKeys;
    }

    protected void setCommaSeparatedFileLookupKeys(String string) {
        this.commaSeparatedFileLookupKeys = string;
    }

    public DistributionOption getDistributionOption() {
        return this.distributionOption;
    }

    public void setDistributionOption(DistributionOption distributionOption) {
        this.distributionOption = distributionOption;
    }

    public Integer getAlertDelayPeriod() {
        return this.alertDelayPeriod;
    }

    public void setAlertDelayPeriod(Integer n) {
        this.alertDelayPeriod = n;
    }

    public String getDistTemplateName() {
        return this.distTemplateName;
    }

    public void setDistTemplateName(String string) {
        this.distTemplateName = string;
    }

    public Map<String, String> getDistConfParams() {
        return this.distConfParams;
    }

    public void setDistConfParams(Map<String, String> map) {
        this.distConfParams = map;
    }

    public String getExportPluginName() {
        return this.exportPluginName;
    }

    public void setExportPluginName(String string) {
        this.exportPluginName = string;
    }

    public Map<String, String> getExportConfParams() {
        return this.exportConfParams;
    }

    public void setExportConfParams(Map<String, String> map) {
        this.exportConfParams = map;
    }

    public Long getAssociatedResourceId() {
        return this.associatedResourceId;
    }

    public void setAssociatedResourceId(Long l) {
        this.associatedResourceId = l;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.getClass() == object.getClass();
    }
}

