/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import java.util.HashSet;
import java.util.Set;

public class TrackingSite
extends Site {
    private static final long serialVersionUID = -9193525032417805770L;
    private static final Set<Site> EMPTY_CHILDREN = new HashSet<Site>();
    private Set<DistributionSite> parents;
    private Integer alertDelayPeriod;

    @Override
    public Set<Site> getSiteChildren() {
        return EMPTY_CHILDREN;
    }

    public void addParent(DistributionSite distributionSite) {
        if (this.parents == null) {
            this.parents = new HashSet<DistributionSite>();
        }
        this.parents.add(distributionSite);
    }

    public void clearParents() {
        if (this.parents != null) {
            this.parents.clear();
        }
    }

    public void setParents(Set<DistributionSite> set) {
        this.parents = set;
    }

    public Set<DistributionSite> getParents() {
        return this.parents;
    }

    @Override
    public SiteType getType() {
        return SiteType.TRACKING;
    }

    @Override
    public Set<Site> getSiteParents() {
        HashSet<Site> hashSet = new HashSet<Site>();
        if (this.parents != null) {
            for (DistributionSite distributionSite : this.parents) {
                hashSet.add(distributionSite);
            }
        }
        return hashSet;
    }

    public Integer getAlertDelayPeriod() {
        return this.alertDelayPeriod;
    }

    public void setAlertDelayPeriod(Integer n) {
        this.alertDelayPeriod = n;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.getClass() == object.getClass();
    }
}

