#!/bin/sh

dir=/opt/tandbergtv/cms/conf/pmm
file=$dir/table-config.xml
tmpFile=$dir/tmp_table-config.xml

if grep SeriesSearchResultsColumns $file >> /dev/null
	then
		echo "table-config.xml is already upgraded";
		exit;
fi

message='<!-- Extra data for SERIES search columns --> \n 
     <table id="SeriesSearchResultsColumns" defaultSortingColumn="id" defaultSortingOrder="DESCENDING" actionPath="" defaultColumnWidth=""> \t \n
		<Column> \t \n
			<ColumnName>Series Id</ColumnName> \t \n
			<MethodName>id</MethodName> \t \n
			<SortingColumnName>id</SortingColumnName> \t \n
			<isSelectedByDefault>true</isSelectedByDefault> \t \n
		</Column> \t \n
		<Column> \t \n
			<ColumnName>Thumbnail</ColumnName> \t \n
			<MethodName>thumbnail</MethodName> \t \n
			<isSelectedByDefault>true</isSelectedByDefault> \t \n
		</Column> \t \n		
		<Column> \t \n
			<TableExtensionKey>seriesMetadataSearchColumns</TableExtensionKey> \t \n
			<TableExtensionLoaderImpl>com.tandbergtv.watchpoint.pmm.web.title.TitleTableExtensionLoader</TableExtensionLoaderImpl> \t \n
		</Column> \t \n
     </table> \t \n
     </tables>'

# take backup of old file
cp $file $dir/table_config.xml.beforeUpgrade

# Delete the line
grep -v "</tables>" $file > $tmpFile

# append the line as a part of upgrade
echo -e $message  >> $tmpFile

#rename the file
mv -f $tmpFile $file



