#!/bin/sh

dir=/opt/tandbergtv/cms/conf/tools
linksfile=$dir/links.xml
linkNameFile=$dir/LinkName.properties
tmpFile=$dir/tmp.txt

if grep "#Recording.Home" $linksfile >> /dev/null
 	then
		echo "links.xml is already upgraded";
		exit;
fi

linksMessage='\t<link href="/portal/#Recording.Home" displayName="recording"/> \n 
    </links>' 

linksPropMessage='recording=Recording Manager'
## Upgrade links.xml ##
# take backup of old file
cp $linksfile $dir/links.xml.beforeUpgrade

# Delete the line
grep -v "</links>" $linksfile > $tmpFile

# append the line as a part of upgrade
echo -e $linksMessage  >> $tmpFile

#rename the file
mv -f $tmpFile $linksfile

## Upgrade LinkName.properties ##
cp $linkNameFile $dir/LinkName.properties.beforeUpgrade 
echo $linksPropMessage >> $linkNameFile



