/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.metadatamanager.specimpl.cl1_1;

import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class CL1_1_Identifier
extends IdentifierBase {
    private static final long serialVersionUID = -8112844616094249184L;
    private static String PROVIDERID_XPATH = "ADI/Metadata/AMS/Provider_ID";
    private static String ASSETID_XPATH = "ADI/Metadata/AMS/Asset_ID";
    private String providerId;
    private String assetId;

    public String getAssetId() {
        return this.assetId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public Map<String, String> getSpecIdentifiers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROVIDERID_XPATH, this.providerId);
        map.put(ASSETID_XPATH, this.assetId);
        return map;
    }

    public Map<String, String> getTTVPaths() {
        HashMap<String, String> ttvPaths = new HashMap<String, String>();
        String assetIdXpath = MappingFileParser.getMapping((URL)this.getMappingResourceUrl(), (String)ASSETID_XPATH);
        if (assetIdXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + ASSETID_XPATH + " cannot be mapped to TTV xpath.");
        }
        String providerIdXpath = MappingFileParser.getMapping((URL)this.getMappingResourceUrl(), (String)PROVIDERID_XPATH);
        if (providerIdXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + PROVIDERID_XPATH + " cannot be mapped to TTV xpath.");
        }
        ttvPaths.put(ASSETID_XPATH, assetIdXpath);
        ttvPaths.put(PROVIDERID_XPATH, providerIdXpath);
        return ttvPaths;
    }

    public boolean isValidIdentifier() {
        return this.providerId != null && !this.providerId.equals("") && this.assetId != null && !this.assetId.equals("");
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public void setSpecIdentifiers(Map<String, String> identifiers) {
        if (identifiers.containsKey(ASSETID_XPATH)) {
            this.setAssetId(identifiers.get(ASSETID_XPATH));
        }
        if (identifiers.containsKey(PROVIDERID_XPATH)) {
            this.setProviderId(identifiers.get(PROVIDERID_XPATH));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CL1_1_Identifier)) {
            return false;
        }
        CL1_1_Identifier another = (CL1_1_Identifier)((Object)o);
        return this.isEqual(this.providerId, another.providerId) && this.isEqual(this.assetId, another.assetId);
    }

    private boolean isEqual(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public int hashCode() {
        int h1 = this.providerId != null ? this.providerId.hashCode() : 0;
        int h2 = this.assetId != null ? this.assetId.hashCode() : 0;
        return (h1 + h2 + 7) * 13;
    }

    public String toString() {
        return this.providerId + " | " + this.assetId;
    }
}

