<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns fn xs">

<!-- Imports -->
<xsl:import href="from/common.xsl"/>

<!-- Extra fields from TSTV 3.2 spec -->
<xsl:template name="title_tstv" >

	<!-- Start Time -->
	<xsl:if test="tns:Fields/tns:TvId/tns:Showtime/tns:StartTimeInUtc">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Start_Time</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:TvId/tns:Showtime/tns:StartTimeInUtc" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Contract ID -->
	<xsl:if test="tns:Fields/tns:Rights/tns:Contract/tns:Id/tns:Id">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Contract_ID</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:Rights/tns:Contract/tns:Id/tns:Id" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	
	<!-- Recording Region  -->
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Place/tns:Region">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Recording_Region</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Place/tns:Region" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>

</xsl:template>

</xsl:stylesheet>
