<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	version="1.0">
	<xsl:import href="to/mappedCustomFields.xsl"/>
	<xsl:output method="xml" indent="yes"/>

	<!-- Trial use fields mapped to TTV custom fields -->
	<xsl:template
		match="App_Data[@Name = 'TitleArtist'
						or @Name = 'SongTitle'
						or @Name = 'TitleLanguage'
						or @Name = 'TRANSCODED_MOVIE_FORMAT'
						]"
		mode="mappedCustomFields_optional">
		<xsl:element name="tns:CustomField">
			<xsl:attribute name="name">
				<xsl:value-of select="@Name" />
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@Name = 'SplicingEnabled'">
						<xsl:choose>
							<xsl:when test="@Value = 'Y'">true</xsl:when>
							<xsl:when test="@Value = 'N'">false</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
				    </xsl:when>
				    <xsl:otherwise>
				    	<xsl:value-of select="@Value" />
				    </xsl:otherwise>
			    </xsl:choose>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

	<!-- TSTV fields mapped to TTV custom fields -->
	<xsl:template
		match="App_Data[@Name = 'Content_Type'
						or @Name = 'Channel_ID'
						or @Name = 'End_Time'
						or @Name = 'Record_Priority'
						or @Name = 'Program_Name'
						or @Name = 'Repeat'
						or @Name = 'Playback_Windows'
						or @Name = 'Max_Copies'
						or @Name = 'Delete_Time'
						or @Name = 'Ref_Count'
						or @Name = 'Catalog_Entry'
						or @Name = 'Purge_Time']"
		mode="mappedCustomFields_optional">
		<xsl:element name="tns:CustomField">
			<xsl:attribute name="name">
				<xsl:value-of select="@Name" />
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@Name = 'Repeat' 
										or @Name = 'Catalog_Entry'">
						<xsl:choose>
							<xsl:when test="@Value = 'Y'">true</xsl:when>
							<xsl:when test="@Value = 'N'">false</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>
				    </xsl:when>
				    <xsl:otherwise>
				    	<xsl:value-of select="@Value" />
				    </xsl:otherwise>
			    </xsl:choose>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
