<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:fn="http://www.w3.org/2005/xpath-functions" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	version="1.0"
	exclude-result-prefixes="tns fn xs" >
	
	<xsl:output method="xml" indent="yes"/>

	<!-- Display -->
	<xsl:template match="AMS" mode="display">
		<tns:CreationInfo>
			<tns:CreateDate>
				<xsl:choose>
					<xsl:when test="fn:contains(@Creation_Date, 'T')"><xsl:value-of select="@Creation_Date" /></xsl:when>
					<xsl:otherwise><xsl:value-of select="@Creation_Date" />T00:00:00</xsl:otherwise>
				</xsl:choose>
			</tns:CreateDate>
			<xsl:if test="../App_Data/@Name = 'Year'">
				<tns:PublicationDate>
					<xsl:value-of select="../App_Data[@Name = 'Year']/@Value" />
				</tns:PublicationDate>
			</xsl:if>
		</tns:CreationInfo>
		<tns:Languages>
			<tns:Language>
				<xsl:attribute name="value"><xsl:value-of select="../App_Data[@Name = 'Title' and @Language!='en']/@Language" /></xsl:attribute>
			</tns:Language>
		</tns:Languages>
		<tns:Title>
			<tns:DisplayTitle><tns:Value><xsl:value-of select="../App_Data[@Name = 'Title' and @Language!='en']/@Value" /></tns:Value></tns:DisplayTitle>
			<tns:ShortTitle><tns:Value><xsl:value-of select="../App_Data[@Name = 'Title_Brief' and @Language!='en']/@Value" /></tns:Value></tns:ShortTitle>
			<xsl:if test="../App_Data/@Name = 'Title_Sort_Name'">
				<tns:SortTitle><tns:Value><xsl:value-of select="../App_Data[@Name = 'Title_Sort_Name' and @Language!='en']/@Value" /></tns:Value></tns:SortTitle>
			</xsl:if>
		</tns:Title>
		<tns:Summary>
			<xsl:if test="../App_Data/@Name = 'Summary_Long'">
				<tns:DisplaySummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Long' and @Language!='en']/@Value" /></tns:Value></tns:DisplaySummary>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Summary_Medium'">
				<tns:MediumSummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Medium' and @Language!='en']/@Value" /></tns:Value></tns:MediumSummary>
			</xsl:if>
			<tns:ShortSummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Short' and @Language!='en']/@Value" /></tns:Value></tns:ShortSummary>
		</tns:Summary>
		<xsl:for-each select="../App_Data[@Name = 'Actors' and @Language!='en']">
			<tns:Source>
				<tns:Role>
					<tns:Name>ACTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Actors_Display' and @Language!='en']">
			<tns:Source>
				<tns:Role>
					<tns:Name>ACTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<tns:DisplayName><xsl:value-of select="@Value" /></tns:DisplayName>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Writer_Display' and @Language!='en']">
			<tns:Source>
				<tns:Role>
					<tns:Name>WRITER</tns:Name>
				</tns:Role>
				<tns:Contact>
					<tns:DisplayName><xsl:value-of select="@Value" /></tns:DisplayName>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Director' and @Language!='en']">
			<tns:Source>
				<tns:Role>
					<tns:Name>DIRECTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Producers' and @Language!='en']">
			<tns:Source>
				<tns:Role>
					<tns:Name>PRODUCER</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Genre' and @Language!='en']">
			<tns:Genre>
				<tns:Value><xsl:value-of select="@Value" /></tns:Value>
			</tns:Genre>
		</xsl:for-each>
		<xsl:if test="../App_Data/@Name = 'Show_Type'">
			<tns:ShowType><xsl:value-of select="../App_Data[@Name = 'Show_Type' and @Language!='en']/@Value" /></tns:ShowType>
		</xsl:if>
	</xsl:template>

<!--
	THE WORLD IS NOT READY FOR THIS TO BE DONE THE RIGHT WAY!!!
	<xsl:template name="Category">
		<xsl:param name="catlist" />
		<xsl:variable name="cat" select="substring-before($catlist,'/')" />
		<xsl:choose>
			<xsl:when test="string-length($cat) > 0">
				<tns:Category>
					<tns:Text><xsl:value-of select="$cat"/></tns:Text>
					<xsl:call-template name="Category">
						<xsl:with-param name="catlist">
							<xsl:value-of select="substring-after($catlist,'/')"/>
						</xsl:with-param>
					</xsl:call-template>
				</tns:Category>
			</xsl:when>
			<xsl:otherwise>
				<tns:Category>
					<tns:Text><xsl:value-of select="$catlist"/></tns:Text>
				</tns:Category>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
-->
	<xsl:template name="Category">
		<xsl:param name="catlist" />
		<tns:Category>
			<tns:Text><xsl:value-of select="$catlist"/></tns:Text>
		</tns:Category>
	</xsl:template>

	<xsl:template match="*" />

</xsl:stylesheet>
