<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="tns"  version="2.0">

	<xsl:import href="from/common.xsl"/>

	<xsl:template name="AudioVideo">
		<xsl:param name="masterSourceRef"/>
		<xsl:param name="previewOrTitle"/>
		<xsl:call-template name="ContentAsset">
			<xsl:with-param name="masterSourceRef" select="$masterSourceRef"/>
		</xsl:call-template>
		
		<!-- For an asset with asset_class="encrypted" the values on the "movie" with Asset_ID of the Asset_Encrypted are copied over -->
		<xsl:variable name="assetEncrypted" select="tns:Fields/tns:Encryption/tns:Asset/tns:Identifier/tns:Id" />
		<xsl:variable name="sourceNode" select="//tns:Group[tns:Fields/tns:Identifier/tns:Id=$assetEncrypted] | current()" />
				
		<xsl:for-each select="$sourceNode/tns:Fields/tns:Audio/tns:Type">
			<content:AudioType>
				<xsl:value-of select="$sourceNode/tns:Fields/tns:Audio/tns:Type"/>
			</content:AudioType>
		</xsl:for-each>
		<xsl:if test="$sourceNode/tns:Fields/tns:Video/tns:ScreenFormat">
			<content:ScreenFormat>
				<xsl:value-of select="$sourceNode/tns:Fields/tns:Video/tns:ScreenFormat"/>
			</content:ScreenFormat>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Content/tns:Resolution">
			<content:Resolution><xsl:value-of select="tns:Fields/tns:Content/tns:Resolution"/></content:Resolution>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:CustomFields/tns:CustomField[@name='FrameRate']">
			<content:FrameRate>
				<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='FrameRate']/@value"/>
			</content:FrameRate>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:CustomFields/tns:CustomField[@name='Codec']">
			<content:Codec>
				<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='Codec']/@value"/>
			</content:Codec>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
			<content:BitRate><xsl:value-of select="tns:Fields/tns:Video/tns:BitRate/@value"/></content:BitRate>
		</xsl:if>
		<xsl:if test="$previewOrTitle/tns:Fields/tns:Duration/tns:Duration">			
			<content:Duration>
				<xsl:apply-templates select="$previewOrTitle/tns:Fields/tns:Duration/tns:Duration" mode="stringToDuration"/>
			</content:Duration>
		</xsl:if>
		<xsl:for-each select="$sourceNode/tns:Fields/tns:Language ">
			<content:Language>
				<xsl:value-of select="@value"/>
			</content:Language>
		</xsl:for-each>
		<xsl:for-each select="$sourceNode/tns:Fields/tns:SubTitleLanguage">
			<content:SubtitleLanguage>
				<xsl:value-of select="@value"/>
			</content:SubtitleLanguage>
		</xsl:for-each>
		<xsl:for-each select="$sourceNode/tns:Fields/tns:DubbedLanguage">
			<content:DubbedLanguage>
				<xsl:value-of select="@value"/>
			</content:DubbedLanguage>
		</xsl:for-each>	

		<xsl:for-each select="$previewOrTitle/tns:Fields/tns:Rating/tns:Value">
			<content:Rating>
				<xsl:choose> 
					<xsl:when test="./@system">
						<xsl:attribute name="ratingSystem"><xsl:value-of select="./@system" /></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="exists(index-of(('G','PG','PG-13','R','NC-17'),.))"><xsl:attribute name="ratingSystem">MPAA</xsl:attribute></xsl:when>
							<xsl:when test="starts-with(.,'TV')"><xsl:attribute name="ratingSystem">TV</xsl:attribute></xsl:when>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="."/>
			</content:Rating>
		</xsl:for-each>
		<xsl:for-each select="$previewOrTitle/tns:Fields/tns:Rating/tns:MSORating">
			<content:Rating ratingSystem="MSO">
				<xsl:value-of select="."/>
			</content:Rating>
		</xsl:for-each>
		<xsl:for-each select="$previewOrTitle/tns:Fields/tns:Rating/tns:TargetAudience">
			<content:Audience>
				<xsl:value-of select="."/>
			</content:Audience>
		</xsl:for-each>
			
		<xsl:if test="tns:Fields/tns:Vendor/tns:Name or tns:Fields/tns:Receiver/tns:Type or tns:Fields/tns:Receiver/tns:Version/tns:Value or tns:Fields/tns:Encryption/tns:Type or tns:Fields/tns:Encryption/tns:Algorithm or tns:Fields/tns:Encryption/tns:Date or tns:Fields/tns:Encryption/tns:Time or tns:Fields/tns:Encryption/tns:SystemInfo or tns:Fields/tns:Encryption/tns:KeyBlock">
			<content:EncryptionInfo>
				<xsl:if test="tns:Fields/tns:Vendor/tns:Name">
					<content:VendorName>
						<xsl:value-of select="tns:Fields/tns:Vendor/tns:Name"/>
					</content:VendorName>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Receiver/tns:Type">
					<content:ReceiverType>
						<xsl:value-of select="tns:Fields/tns:Receiver/tns:Type"/>
					</content:ReceiverType>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Receiver/tns:Version/tns:Value">
					<content:ReceiverVersion>
						<xsl:value-of select="tns:Fields/tns:Receiver/tns:Version/tns:Value"/>
					</content:ReceiverVersion>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Encryption/tns:Type">
					<content:Encryption>
						<xsl:value-of select="tns:Fields/tns:Encryption/tns:Type"/>
					</content:Encryption>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Encryption/tns:Algorithm">
					<content:EncryptionAlgorithm>
						<xsl:value-of select="tns:Fields/tns:Encryption/tns:Algorithm"/>
					</content:EncryptionAlgorithm>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Encryption/tns:Date">
					<content:EncryptionDateTime>
						<xsl:choose>
							<xsl:when test="string-length(tns:Fields/tns:Encryption/tns:Time) > 0">
								<xsl:value-of select="concat(substring-before(tns:Fields/tns:Encryption/tns:Date,'T'),'T',tns:Fields/tns:Encryption/tns:Time,'Z')"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat(tns:Fields/tns:Encryption/tns:Date, 'Z')" />
							</xsl:otherwise>
						</xsl:choose>
					</content:EncryptionDateTime>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Encryption/tns:SystemInfo">
					<content:EncryptionSystemInfo>
						<xsl:value-of select="tns:Fields/tns:Encryption/tns:SystemInfo"/>
					</content:EncryptionSystemInfo>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Encryption/tns:KeyBlock">
					<content:EncryptionKeyBlock>
						<xsl:value-of select="tns:Fields/tns:Encryption/tns:KeyBlock"/>
					</content:EncryptionKeyBlock>
				</xsl:if>
			</content:EncryptionInfo>
		</xsl:if>

		<xsl:if test="tns:Fields/tns:Copyright/tns:EncryptionModeIndicator or tns:Fields/tns:Copyright/tns:ConstrainedImageTrigger or tns:Fields/tns:Copyright/tns:CGMSA or tns:Fields/tns:Copyright/tns:CopyProtection or tns:Fields/tns:Copyright/tns:CopyProtectionVerbose or tns:Fields/tns:Copyright/tns:AnalogProtectionSystem">		
			<content:CopyControlInfo>
				<xsl:if test="tns:Fields/tns:Copyright/tns:CopyProtection">
					<content:IsCopyProtection><xsl:value-of select="tns:Fields/tns:Copyright/tns:CopyProtection"/></content:IsCopyProtection>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Copyright/tns:CopyProtectionVerbose">
					<content:IsCopyProtectionVerbose><xsl:value-of select="tns:Fields/tns:Copyright/tns:CopyProtectionVerbose"/></content:IsCopyProtectionVerbose>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Copyright/tns:AnalogProtectionSystem">
					<content:AnalogProtectionSystem>
						<xsl:value-of select="tns:Fields/tns:Copyright/tns:AnalogProtectionSystem"/>
					</content:AnalogProtectionSystem>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Copyright/tns:EncryptionModeIndicator">
					<content:EncryptionModeIndicator>
						<xsl:value-of select="tns:Fields/tns:Copyright/tns:EncryptionModeIndicator"/>
					</content:EncryptionModeIndicator>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Copyright/tns:ConstrainedImageTrigger">
					<content:ConstrainedImageTrigger>
						<xsl:value-of select="tns:Fields/tns:Copyright/tns:ConstrainedImageTrigger"/>
					</content:ConstrainedImageTrigger>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Copyright/tns:CGMSA">
					<content:CGMS_A>
						<xsl:value-of select="tns:Fields/tns:Copyright/tns:CGMSA"/>
					</content:CGMS_A>
				</xsl:if>
			</content:CopyControlInfo>
		</xsl:if>
		<!-- really should be on Terms -->
		<xsl:if test="$sourceNode/tns:Fields/tns:Rights/tns:ViewingCanBeResumed">
			<content:IsResumeEnabled><xsl:value-of select="$sourceNode/tns:Fields/tns:Rights/tns:ViewingCanBeResumed"/></content:IsResumeEnabled>
		</xsl:if>
		
		<xsl:for-each select="$sourceNode/tns:Fields/tns:CustomFields/tns:CustomField[@name='trickModesRestricted']">
			<xsl:for-each select="tokenize(@value, ',')">
				<content:TrickModesRestricted><xsl:value-of select="normalize-space(.)"/></content:TrickModesRestricted>
			</xsl:for-each>
		</xsl:for-each>

		<!-- Ext -->
	</xsl:template>

</xsl:stylesheet>