<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns"  version="2.0">

	<xsl:template name="AMS_1">
		<xsl:if test="tns:Fields/tns:Version/tns:Major">
			<xsl:attribute name="providerVersionNum">
				<xsl:value-of select="tns:Fields/tns:Version/tns:Major"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Version/tns:Minor">
			<xsl:attribute name="internalVersionNum">
				<xsl:value-of select="tns:Fields/tns:Version/tns:Minor"/>
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:CreationInfo/tns:CreateDate">
			<xsl:attribute name="creationDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:CreateDate"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/tns:Fields/tns:Rights/tns:LicensingWindowStart">
			<xsl:attribute name="startDateTime">
				<xsl:call-template name="startDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/tns:Fields/tns:Rights/tns:LicensingWindowStart"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="$Title/tns:Fields/tns:Rights/tns:LicensingWindowEnd">
			<xsl:attribute name="endDateTime">
				<xsl:call-template name="endDateTime">
					<xsl:with-param name="dateString">
						<xsl:value-of select="$Title/tns:Fields/tns:Rights/tns:LicensingWindowEnd"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:attribute>
		</xsl:if>
		
		<xsl:if test="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id and tns:Fields/tns:Identifier/tns:Id">
			<core:AlternateId identifierSystem="VOD1.1">
				<xsl:value-of select="concat('vod://',tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id,'/',tns:Fields/tns:Identifier/tns:Id)"/>
			</core:AlternateId>
		</xsl:if>
	</xsl:template>

	<xsl:template name="AMS_2">
		<xsl:if test="tns:Fields/tns:AssetName">
			<core:AssetName deprecated="true">
				<xsl:value-of select="tns:Fields/tns:AssetName"/>
			</core:AssetName>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:ProductInfo/tns:Name">
			<core:Product deprecated="true">
				<xsl:value-of select="tns:Fields/tns:ProductInfo/tns:Name"/>
			</core:Product>
		</xsl:if>		
		<xsl:if test="tns:Fields/tns:ProviderInfo/tns:Name">
			<core:Provider deprecated="true">
				<xsl:value-of select="tns:Fields/tns:ProviderInfo/tns:Name"/>
			</core:Provider>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Description/tns:Text">
			<core:Description deprecated="true">
				<xsl:choose>
					<xsl:when test="string-length(tns:Fields/tns:Description/tns:Text) > 100">
						<xsl:value-of select="substring(tns:Fields/tns:Description/tns:Text, 0, 100)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="tns:Fields/tns:Description/tns:Text"/>
					</xsl:otherwise>
				</xsl:choose>
			</core:Description>
		</xsl:if>
		<core:Ext>
			<xsl:apply-templates select="tns:Fields/tns:CustomFields/tns:CustomField" />
		</core:Ext>
	</xsl:template>

	<xsl:template name="ContentAsset">
		<xsl:param name="masterSourceRef"/>
		<xsl:attribute name="uriId"><xsl:value-of select="concat( tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id, '/Asset/', tns:Fields/tns:Identifier/tns:Id )"/></xsl:attribute>

		<xsl:call-template name="AMS_1" />
		<xsl:call-template name="AMS_2" />

		<xsl:if test="$masterSourceRef">
			<content:MasterSourceRef>
				<xsl:attribute name="uriId"><xsl:value-of select="$masterSourceRef"/></xsl:attribute>
			</content:MasterSourceRef>
		</xsl:if>	
		<xsl:if test="tns:Fields/tns:Content/tns:Locator/tns:Uri">
			<content:SourceUrl>
				<xsl:value-of select="tns:Fields/tns:Content/tns:Locator/tns:Uri"/>
			</content:SourceUrl>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Content/tns:Size/tns:length">
			<content:ContentFileSize>
				<xsl:value-of select="tns:Fields/tns:Content/tns:Size/tns:length"/>
			</content:ContentFileSize>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Content/tns:Checksum">
			<content:ContentCheckSum>
				<xsl:value-of select="tns:Fields/tns:Content/tns:Checksum"/>
			</content:ContentCheckSum>
		</xsl:if>
		<xsl:if test="$Title/tns:Fields/tns:PropagationPriority" >
			<content:PropagationPriority>
				<!-- grab any one (max??) -->
				<xsl:value-of select="$Title/tns:Fields/tns:PropagationPriority"/>
			</content:PropagationPriority>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:CustomFields/tns:CustomField[@name='ContentRef']">
			<content:ContentRef>
				<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='ContentRef']/@value"/>
			</content:ContentRef>
		</xsl:if>

	</xsl:template>

	<xsl:template name="startDateTime">
		<xsl:param name="dateString" />
		<xsl:choose>
			<xsl:when test="string-length($dateString) = 10"><xsl:value-of select="concat($dateString,'T00:00:00Z')"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="concat($dateString,'Z')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="endDateTime">
		<xsl:param name="dateString" />
		<xsl:choose>
			<xsl:when test="string-length($dateString) = 10"><xsl:value-of select="concat($dateString,'T23:59:59Z')"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="concat($dateString,'Z')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*|@*" mode="stringToDuration">
		<xsl:variable name="hours" select="concat('PT',substring-before(., ':'),'H')"/>
		<xsl:variable name="remaining" select="substring-after(., ':')"/>
		<xsl:variable name="minutes" select="concat(substring-before($remaining, ':'),'M')"/>
		<xsl:variable name="seconds" select="concat(substring-after($remaining, ':'),'S')"/>
		<xsl:value-of select="concat($hours,$minutes,$seconds)"/>
	</xsl:template>

	<xsl:template name="durationInSecs">
		<xsl:param name="duration" />

	    <xsl:variable name="hours">
	      <xsl:value-of select="substring($duration,1,2)" />
    	</xsl:variable>
	    <xsl:variable name="minutes">
	      <xsl:value-of select="substring($duration,4,2)" />
    	</xsl:variable>
	    <xsl:variable name="seconds">
	      <xsl:value-of select="substring($duration,7,2)" />
    	</xsl:variable>
    	
    	<xsl:value-of select="($hours * 60 * 60) + ($minutes * 60) + $seconds"/>
    	
	</xsl:template>

	<xsl:template name="customField">
		<xsl:param name="app"/>
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		
		<xsl:if test="$value != ''">
			<App_Data>
				<xsl:attribute name="App"><xsl:value-of select="$app"/></xsl:attribute>
				<xsl:attribute name="Name"><xsl:value-of select="$name"/></xsl:attribute>
				<xsl:attribute name="Value"><xsl:value-of select="$value"/></xsl:attribute>
			</App_Data>
		</xsl:if>

	</xsl:template>
</xsl:stylesheet>