<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns"  version="2.0">
	
	<xsl:import href="from/common.xsl"/>
	
	<xsl:template name="StillImage">
		<xsl:param name="Asset" />

		<xsl:call-template name="ContentAsset" />
		<xsl:variable name="ImageAspect" select="tns:Fields/tns:Image/tns:AspectRatio"/>
		<xsl:variable name="sourceNode" select="current()" />
		<xsl:if test="contains($ImageAspect, 'x')">
			<xsl:variable name="x" select="substring-before($ImageAspect, 'x')"/>
			<xsl:variable name="y" select="substring-after($ImageAspect, 'x')"/>
			<xsl:if test="$x">
				<content:X_Resolution>
					<xsl:value-of select="$x"/>
				</content:X_Resolution>
			</xsl:if>
			<xsl:if test="$y">
				<content:Y_Resolution>
					<xsl:value-of select="$y"/>
				</content:Y_Resolution>
			</xsl:if>
		</xsl:if>

		<xsl:if test="contains($ImageAspect, 'X')">
			<xsl:variable name="x" select="substring-before($ImageAspect, 'X')"/>
			<xsl:variable name="y" select="substring-after($ImageAspect, 'X')"/>
			<xsl:if test="$x">
				<content:X_Resolution>
					<xsl:value-of select="$x"/>
				</content:X_Resolution>
			</xsl:if>
			<xsl:if test="$y">
				<content:Y_Resolution>
					<xsl:value-of select="$y"/>
				</content:Y_Resolution>
			</xsl:if>
		</xsl:if>

		<xsl:for-each select="$sourceNode/tns:Fields/tns:Language">
			<content:Language>
				<xsl:value-of select="@value"/>
			</content:Language>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet>