<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns"  version="2.0">

	<xsl:import href="from/common.xsl"/>
	
	<xsl:template match="/tns:TTVSpec/tns:Item[@type = 'TITLE']">
		<xsl:call-template name="Title"/>
		<xsl:call-template name="ContentGroup"/>
		<xsl:call-template name="Terms"/>
		<xsl:call-template name="Category"/>
	</xsl:template>
	
	<xsl:template name="Title">
		<Title>
			<xsl:attribute name="uriId"><xsl:value-of select="$TitleUriId"/></xsl:attribute>
			<xsl:call-template name="AMS_1" />
			<xsl:if test="tns:Fields/tns:ISAN">
				<core:AlternateId identifierSystem="ISAN">
					<xsl:value-of select="tns:Fields/tns:ISAN"/>
				</core:AlternateId>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:ProviderQAContact/tns:Value">
				<core:ProviderQAContact>
					<xsl:value-of select="tns:Fields/tns:ProviderQAContact/tns:Value"/>
				</core:ProviderQAContact>
			</xsl:if>
			<xsl:call-template name="AMS_2" />

			<title:LocalizableTitle>
				<xsl:if test="tns:Fields/tns:Title/tns:SortTitle/tns:Value">
					<title:TitleSortName>
						<xsl:value-of select="tns:Fields/tns:Title/tns:SortTitle/tns:Value"/>
					</title:TitleSortName>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="tns:Fields/tns:Title/tns:ShortTitle/tns:Value">
						<title:TitleBrief>
							<xsl:value-of select="substring(tns:Fields/tns:Title/tns:ShortTitle/tns:Value,1,19)"/>
						</title:TitleBrief>
						<title:TitleMedium>
							<xsl:value-of select="substring(tns:Fields/tns:Title/tns:ShortTitle/tns:Value,1,35)"/>
						</title:TitleMedium>
					</xsl:when>		
					<xsl:otherwise>
						<title:TitleBrief>
							<xsl:value-of select="substring(tns:Fields/tns:Title/tns:DisplayTitle/tns:Value,1,19)"/>
						</title:TitleBrief>
						<title:TitleMedium>
							<xsl:value-of select="substring(tns:Fields/tns:Title/tns:DisplayTitle/tns:Value,1,35)"/>
						</title:TitleMedium>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="tns:Fields/tns:Title/tns:DisplayTitle/tns:Value">
					<title:TitleLong>
						<xsl:value-of select="tns:Fields/tns:Title/tns:DisplayTitle/tns:Value"/>
					</title:TitleLong>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Summary/tns:ShortSummary/tns:Value">
					<title:SummaryShort>
						<xsl:value-of select="tns:Fields/tns:Summary/tns:ShortSummary/tns:Value"/>
					</title:SummaryShort>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Summary/tns:MediumSummary/tns:Value">
					<title:SummaryMedium>
						<xsl:value-of select="tns:Fields/tns:Summary/tns:MediumSummary/tns:Value"/>
					</title:SummaryMedium>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Summary/tns:DisplaySummary/tns:Value">
					<title:SummaryLong>
						<xsl:value-of select="tns:Fields/tns:Summary/tns:DisplaySummary/tns:Value"/>
					</title:SummaryLong>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'ACTOR']">
					<title:ActorDisplay>
						<xsl:for-each select="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'ACTOR'] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:ActorDisplay>
				</xsl:if>
				<xsl:for-each select="tns:Fields/tns:Source/tns:Contact[../tns:Role/tns:Name = 'ACTOR'] ">
					<title:Actor>
						<xsl:if test="normalize-space(tns:FirstName/.) != '' or normalize-space(tns:LastName/.) != '' or normalize-space(tns:DisplayName/.) != ''">
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(tns:DisplayName/.) != ''">
										<xsl:value-of select="tns:DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="concat(tns:FirstName/., ' ', tns:LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
											<xsl:value-of select="tns:FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="tns:LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:if test="normalize-space(tns:FirstName/.) != ''">
								<xsl:attribute name="firstName"><xsl:value-of select="tns:FirstName/."/></xsl:attribute>
							</xsl:if>
							<xsl:if test="normalize-space(tns:LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="tns:LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="concat(tns:LastName/., ', ', tns:FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
									<xsl:value-of select="tns:FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="tns:LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</xsl:if>
					</title:Actor>
				</xsl:for-each>
				
				<xsl:if test="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'WRITER']">
					<title:WriterDisplay>
						<xsl:for-each select="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'WRITER'] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:WriterDisplay>
				</xsl:if>
				<xsl:for-each select="tns:Fields/tns:Source/tns:Contact[../tns:Role/tns:Name = 'WRITER'] ">
					<title:Writer>
						<xsl:if test="normalize-space(tns:FirstName/.) != '' or normalize-space(tns:LastName/.) != '' or normalize-space(tns:DisplayName/.) != ''">
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(tns:DisplayName/.) != ''">
										<xsl:value-of select="tns:DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="concat(tns:FirstName/., ' ', tns:LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
											<xsl:value-of select="tns:FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="tns:LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:if test="normalize-space(tns:FirstName/.) != ''">
								<xsl:attribute name="firstName"><xsl:value-of select="tns:FirstName/."/></xsl:attribute>
							</xsl:if>
							<xsl:if test="normalize-space(tns:LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="tns:LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="concat(tns:LastName/., ', ', tns:FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
									<xsl:value-of select="tns:FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="tns:LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</xsl:if>
					</title:Writer>
				</xsl:for-each>

				<xsl:if test="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'DIRECTOR']">
					<title:DirectorDisplay>
						<xsl:for-each select="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'DIRECTOR'] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:DirectorDisplay>
				</xsl:if>
				<xsl:for-each select="tns:Fields/tns:Source/tns:Contact[../tns:Role/tns:Name = 'DIRECTOR'] ">
					<title:Director>
						<xsl:if test="normalize-space(tns:FirstName/.) != '' or normalize-space(tns:LastName/.) != '' or normalize-space(tns:DisplayName/.) != ''">
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(tns:DisplayName/.) != ''">
										<xsl:value-of select="tns:DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="concat(tns:FirstName/., ' ', tns:LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
											<xsl:value-of select="tns:FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="tns:LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:if test="normalize-space(tns:FirstName/.) != ''">
								<xsl:attribute name="firstName"><xsl:value-of select="tns:FirstName/."/></xsl:attribute>
							</xsl:if>
							<xsl:if test="normalize-space(tns:LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="tns:LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="concat(tns:LastName/., ', ', tns:FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
									<xsl:value-of select="tns:FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="tns:LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</xsl:if>
					</title:Director>
				</xsl:for-each>

				<xsl:if test="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'PRODUCER']">
					<title:ProducerDisplay>
						<xsl:for-each select="tns:Fields/tns:Source/tns:Contact/tns:DisplayName[../../tns:Role/tns:Name = 'PRODUCER'] ">
							<xsl:value-of select="."/>
							<xsl:if test="not(position() = last())">,</xsl:if>
						</xsl:for-each>
					</title:ProducerDisplay>
				</xsl:if>
				<xsl:for-each select="tns:Fields/tns:Source/tns:Contact[../tns:Role/tns:Name = 'PRODUCER'] ">
					<title:Producer>
						<xsl:if test="normalize-space(tns:FirstName/.) != '' or normalize-space(tns:LastName/.) != '' or normalize-space(tns:DisplayName/.) != ''">
							<xsl:attribute name="fullName">
								<xsl:choose>
									<xsl:when test="normalize-space(tns:DisplayName/.) != ''">
										<xsl:value-of select="tns:DisplayName/."/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="concat(tns:FirstName/., ' ', tns:LastName/.)"/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
											<xsl:value-of select="tns:FirstName/."/>
										</xsl:if>
										<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
											<xsl:value-of select="tns:LastName/."/>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>

							<xsl:if test="normalize-space(tns:FirstName/.) != ''">
								<xsl:attribute name="firstName"><xsl:value-of select="tns:FirstName/."/></xsl:attribute>
							</xsl:if>
							<xsl:if test="normalize-space(tns:LastName/.) != ''">
								<xsl:attribute name="lastName"><xsl:value-of select="tns:LastName/."/></xsl:attribute>
							</xsl:if>
							<xsl:attribute name="sortableName">
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="concat(tns:LastName/., ', ', tns:FirstName/.)"/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) != '' and normalize-space(tns:LastName/.) = ''">
									<xsl:value-of select="tns:FirstName/."/>
								</xsl:if>
								<xsl:if test="normalize-space(tns:FirstName/.) = '' and normalize-space(tns:LastName/.) != ''">
									<xsl:value-of select="tns:LastName/."/>
								</xsl:if>
							</xsl:attribute>
						</xsl:if>
					</title:Producer>
				</xsl:for-each>

				<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:DisplayName">
					<title:StudioDisplay>
						<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:DisplayName"/>
					</title:StudioDisplay>
				</xsl:if>
				<xsl:for-each select="tns:Fields/tns:CustomFields/tns:CustomField[@name='RecordingArtist']">
					<title:RecordingArtist>
						<xsl:value-of select="@value"/>
					</title:RecordingArtist>
				</xsl:for-each>
				<xsl:for-each select="tns:Fields/tns:CustomFields/tns:CustomField[@name='SongTitle']">
					<title:SongTitle>
						<xsl:value-of select="@value"/>
					</title:SongTitle>
				</xsl:for-each>

				<xsl:if test="tns:Fields/tns:Episode/tns:Name/tns:Value">
					<title:EpisodeName deprecated="true">
						<xsl:value-of select="tns:Fields/tns:Episode/tns:Name/tns:Value"/>
					</title:EpisodeName>
				</xsl:if>
				<xsl:if test="tns:Fields/tns:Episode/tns:Identifier/tns:Id">
					<title:EpisodeID deprecated="true">
						<xsl:value-of select="tns:Fields/tns:Episode/tns:Identifier/tns:Id"/>
					</title:EpisodeID>
				</xsl:if>
				<xsl:for-each select="tns:Fields/tns:Chapter">
					<title:Chapter>
						<xsl:attribute name="heading">
							<xsl:value-of select="substring-after(tns:Fields/tns:Chapter, ',')"/>
						</xsl:attribute>	
						<xsl:attribute name="timeCode">
							<xsl:value-of select="substring-before(tns:Fields/tns:Chapter, ',')"/>
						</xsl:attribute>
					</title:Chapter>
				</xsl:for-each>
			</title:LocalizableTitle>
			<xsl:for-each select="tns:Fields/tns:Rating/tns:Value">
				<title:Rating>
					<xsl:choose> 
						<xsl:when test="./@system">
							<xsl:attribute name="ratingSystem"><xsl:value-of select="./@system" /></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="exists(index-of(('G','PG','PG-13','R','NC-17'),.))"><xsl:attribute name="ratingSystem">MPAA</xsl:attribute></xsl:when>
								<xsl:when test="starts-with(.,'TV')"><xsl:attribute name="ratingSystem">TV</xsl:attribute></xsl:when>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="."/>
				</title:Rating>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Rating/tns:MSORating">
				<title:Rating ratingSystem="MSO">
					<xsl:value-of select="."/>
				</title:Rating>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Rating/tns:TargetAudience">
				<title:Audience>
					<xsl:value-of select="."/>
				</title:Audience>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Rating/tns:ContentAdvisory">
				<title:Advisory>
					<xsl:value-of select="."/>
				</title:Advisory>
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:Caption/tns:Value='true'">
				<title:IsClosedCaptioning>true</title:IsClosedCaptioning>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Caption/tns:Value='false'">
				<title:IsClosedCaptioning>false</title:IsClosedCaptioning>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Duration/tns:DisplayDuration">
				<title:DisplayRunTime>
					<xsl:value-of select="tns:Fields/tns:Duration/tns:DisplayDuration"/>
				</title:DisplayRunTime>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:CreationInfo/tns:PublicationDate">
				<title:Year><xsl:value-of select="tns:Fields/tns:CreationInfo/tns:PublicationDate"/></title:Year>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:CreationInfo/tns:Place/tns:Country">
				<title:CountryOfOrigin>
					<xsl:choose>
						<xsl:when test="tns:Fields/tns:CreationInfo/tns:Place/tns:Country = 'United States'">US</xsl:when>
						<xsl:otherwise><xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Place/tns:Country"/></xsl:otherwise>
					</xsl:choose>
				</title:CountryOfOrigin>
			</xsl:if>
			<xsl:for-each select="tns:Fields/tns:Genre/tns:Value">
				<title:Genre>
					<xsl:value-of select="."/>
				</title:Genre>
			</xsl:for-each>
			<xsl:if test="count(tns:Fields/tns:Genre/tns:Value)=0">
				<title:Genre>private:UNKNOWN</title:Genre>
			</xsl:if>
			<title:ShowType>
				<xsl:choose>
					<xsl:when test="tns:Fields/tns:ShowType"><xsl:value-of select="tns:Fields/tns:ShowType"/></xsl:when>
					<xsl:otherwise>private:UNKNOWN</xsl:otherwise>
				</xsl:choose>
			</title:ShowType>
			<xsl:if test="tns:Fields/tns:Episode/tns:SeasonPremier">
				<title:IsSeasonPremier deprecated="true"><xsl:value-of select="tns:Fields/tns:Episode/tns:SeasonPremier"/></title:IsSeasonPremier>
			</xsl:if>

			<xsl:if test="tns:Fields/tns:Episode/tns:SeasonFinale">
				<title:IsSeasonFinale deprecated="true"><xsl:value-of select="tns:Fields/tns:Episode/tns:SeasonFinale"/></title:IsSeasonFinale>
			</xsl:if>
			<!-- TODO:  a bit weird as this is per movie in ADI1.1, should be deprecated? we are lazy and just find it any Encryption="Y" -->
			<xsl:if test="//tns:Fields/tns:Encryption/tns:Value = 'true'">
				<title:IsEncryptionRequired>true</title:IsEncryptionRequired>
			</xsl:if>
			<xsl:if test="not(//tns:Fields/tns:Encryption/tns:Value = 'true') and //tns:Fields/tns:Encryption/tns:Value = 'false'">
				<title:IsEncryptionRequired>false</title:IsEncryptionRequired>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:BoxOffice/tns:Value">
				<title:BoxOffice><xsl:value-of select="tns:Fields/tns:BoxOffice/tns:Value"/></title:BoxOffice>
			</xsl:if>

			<xsl:if test="tns:Fields/tns:CustomFields/tns:CustomField[@name='ProgrammerCallLetters']">
				<title:ProgrammerCallLetters>
					<xsl:value-of select="tns:Fields/tns:CustomFields/tns:CustomField[@name='ProgrammerCallLetters']/@value"/>
				</title:ProgrammerCallLetters>
			</xsl:if>

		</Title>
	</xsl:template>

	<xsl:template name="ContentGroup">
		<ContentGroup>
			<xsl:attribute name="uriId"><xsl:value-of select="$ContentGroupUriId"/></xsl:attribute>
			<xsl:call-template name="AMS_1" />
			<offer:TitleRef>
				<xsl:attribute name="uriId"><xsl:value-of select="$TitleUriId"/></xsl:attribute>
			</offer:TitleRef>
			<xsl:for-each select="//tns:Item">
				<xsl:variable name="uriId">
					<xsl:value-of select="concat( ./tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id, '/Asset/', ./tns:Fields/tns:Identifier/tns:Id)"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="@type='ENCRYPTED'"><offer:MovieRef uriId="{$uriId}"/></xsl:when>
					<xsl:when test="@type='BARKER'"><offer:BarkerRef uriId="{$uriId}"/></xsl:when>
					<xsl:when test="@type='BOXCOVER'"><offer:BoxCoverRef uriId="{$uriId}"/></xsl:when>
					<xsl:when test="@type='POSTER'"><offer:PosterRef uriId="{$uriId}"/></xsl:when>
					<xsl:when test="@type='TRICK'"><offer:TrickRef uriId="{$uriId}"/></xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="//tns:Group">
				<xsl:variable name="uriId">
					<xsl:value-of select="concat( ./tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id, '/Asset/', ./tns:Fields/tns:Identifier/tns:Id)"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="@type='MOVIE'"><offer:MovieRef uriId="{$uriId}"/></xsl:when>
					<xsl:when test="@type='PREVIEW'"><offer:PreviewRef uriId="{$uriId}"/></xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</ContentGroup>
	</xsl:template>

	<xsl:template name="Terms">
		<Terms>
			<xsl:attribute name="uriId"><xsl:value-of select="$TermsUriId"/></xsl:attribute>
			<xsl:call-template name="AMS_1" />
			<xsl:if test="tns:Fields/tns:Rights/tns:Contract/tns:Name">
				<terms:ContractName>
					<xsl:value-of select="tns:Fields/tns:Rights/tns:Contract/tns:Name"/>
				</terms:ContractName>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration">
				<terms:BillingGracePeriod>PT<xsl:call-template name="durationInSecs"><xsl:with-param name="duration" select="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration" /></xsl:call-template>S</terms:BillingGracePeriod>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Rights/tns:MaxViewingLimit">
				<terms:RentalPeriod>
					<xsl:variable name="MaxViewingLength" select="tns:Fields/tns:Rights/tns:MaxViewingLimit"/>
					<xsl:variable name="days" select="xs:integer($MaxViewingLength div 1440)"/>
					<xsl:variable name="hours" select="xs:integer(($MaxViewingLength - ($days * 1440)) div 60)"/>
					<xsl:variable name="minutes" select="$MaxViewingLength mod 60"/>
			    	<xsl:choose>
				    	<xsl:when test="$days = 1 and $hours = 0 and $minutes = 0">00DT24H00M</xsl:when>
				    	<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="$days &lt; 10">
									<xsl:choose>
										<xsl:when test="$hours &lt; 10">
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P0',$days,'DT0',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P0',$days,'DT0',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P0',$days,'DT',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P0',$days,'DT',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="$hours &lt; 10">
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P',$days,'DT0',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P',$days,'DT0',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="$minutes &lt; 10">
													<xsl:value-of select="concat('P',$days,'DT',$hours,'H0',$minutes,'M')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="concat('P',$days,'DT',$hours,'H',$minutes,'M')"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</terms:RentalPeriod>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Rights/tns:HomeVideoWindow">
				<terms:HomeVideoWindow>
					<xsl:value-of select="concat('P',tns:Fields/tns:Rights/tns:HomeVideoWindow,'D') "/>
				</terms:HomeVideoWindow>
			</xsl:if>
			
			<xsl:for-each select="tns:Fields/tns:Rights/tns:MaxViewLimit">
				<xsl:variable name="subscriberViewLimit" select="tokenize(., ',')"/>
				<terms:SubscriberViewLimit>
					<xsl:attribute name="startDateTime">
						<xsl:call-template name="startDateTime">
							<xsl:with-param name="dateString" select="$subscriberViewLimit[1]" />
						</xsl:call-template>
					</xsl:attribute>
					<xsl:attribute name="endDateTime">
						<xsl:call-template name="endDateTime">
							<xsl:with-param name="dateString" select="$subscriberViewLimit[2]" />
						</xsl:call-template>
					</xsl:attribute>				
					<xsl:attribute name="maximumViews"><xsl:value-of select="$subscriberViewLimit[3]"/></xsl:attribute>	
				</terms:SubscriberViewLimit>
			</xsl:for-each>

			<terms:SuggestedPrice>
				<xsl:choose>
					<xsl:when test="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value">
						<xsl:value-of select="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value"/>
					</xsl:when>
					<xsl:otherwise>0.00</xsl:otherwise>
				</xsl:choose>
			</terms:SuggestedPrice>

			<xsl:if test="tns:Fields/tns:Distributor/tns:Name or tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyPercent or tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyMinimum or tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
				<terms:DistributorRoyaltyInfo>
					<xsl:if test="tns:Fields/tns:Distributor/tns:Name">
						<terms:OrganizationName>
							<xsl:value-of select="tns:Fields/tns:Distributor/tns:Name"/>
						</terms:OrganizationName>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyPercent">
						<terms:RoyaltyPercent>
							<xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyPercent"/>
						</terms:RoyaltyPercent>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyMinimum">
						<terms:RoyaltyMinimum>
							<xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyMinimum"/>
						</terms:RoyaltyMinimum>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
						<terms:RoyaltyFlatRate>
							<xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyFlatRate"/>
						</terms:RoyaltyFlatRate>
					</xsl:if>
				</terms:DistributorRoyaltyInfo>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name or tns:Fields/tns:CreationInfo/tns:Studio/tns:Code or tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyPercent or tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyMinimum or tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
				<terms:StudioRoyaltyInfo>
					<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name">
						<terms:OrganizationName>
							<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name"/>
						</terms:OrganizationName>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Code">
						<terms:OrganizationCode>
							<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:Code"/>
						</terms:OrganizationCode>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyPercent">
						<terms:RoyaltyPercent>
							<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyPercent"/>
						</terms:RoyaltyPercent>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyMinimum">
						<terms:RoyaltyMinimum>
							<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyMinimum"/>
						</terms:RoyaltyMinimum>
					</xsl:if>
					<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
						<terms:RoyaltyFlatRate>
							<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyFlatRate"/>
						</terms:RoyaltyFlatRate>
					</xsl:if>
				</terms:StudioRoyaltyInfo>
			</xsl:if>
		</Terms>
	</xsl:template>
 
	<xsl:template name="Category">
		<xsl:for-each select="tns:Fields/tns:Category/tns:Text">
			<Category>
				<xsl:attribute name="uriId"><xsl:value-of select="concat( $PackageProviderId, '/Category/', . )"/></xsl:attribute>
				<xsl:for-each select="$Title">
					<xsl:call-template name="AMS_1" />
				</xsl:for-each>
				<offer:CategoryPath>
					<xsl:value-of select="."/>
				</offer:CategoryPath>
			</Category>
		</xsl:for-each>
	</xsl:template>

	<!-- Templates to convert trial use fields -->
	<xsl:template match="tns:Fields/tns:CustomFields/tns:CustomField[../../../@type='TITLE']">
		<xsl:if test="empty(index-of(('RecordingArtist','SongTitle','ProgrammerCallLetters'),@name))">
			<xsl:call-template name="customField">
				<xsl:with-param name="app" select="$Title/tns:Fields/tns:ProductInfo/tns:Name" />
				<xsl:with-param name="name" select="@name" />
				<xsl:with-param name="value" select="@value" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>