<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:vod30="http://www.cablelabs.com/namespaces/metadata/xsd/vod30/1" 
	xmlns:core="http://www.cablelabs.com/namespaces/metadata/xsd/core/1" 
	xmlns:offer="http://www.cablelabs.com/namespaces/metadata/xsd/offer/1" 
	xmlns:title="http://www.cablelabs.com/namespaces/metadata/xsd/title/1" 
	xmlns:terms="http://www.cablelabs.com/namespaces/metadata/xsd/terms/1" 
	xmlns:content="http://www.cablelabs.com/namespaces/metadata/xsd/content/1" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:tns="http://www.tandbergtv.com/TTVSchema"
	exclude-result-prefixes="tns"  version="2.0">

	<xsl:import href="from/common.xsl"/>
	
	<xsl:template match="tns:TTVSpec/tns:Item[@type = 'TRICK']">
		<Trick>
			<xsl:call-template name="ContentAsset"><xsl:with-param name="masterSourceRef"><xsl:value-of select="$TitleUriId"/></xsl:with-param></xsl:call-template>
			<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
				<content:BitRate><xsl:value-of select="tns:Fields/tns:Video/tns:BitRate/@value"/></content:BitRate>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Vendor/tns:Name">
				<content:VendorName>
					<xsl:value-of select="tns:Fields/tns:Vendor/tns:Name"/>
				</content:VendorName>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Vendor/tns:Product">
				<content:VendorProduct>
					<xsl:value-of select="tns:Fields/tns:Vendor/tns:Product"/>
				</content:VendorProduct>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Vendor/tns:ForVersion">
				<content:ForVersion>
					<xsl:value-of select="tns:Fields/tns:Vendor/tns:ForVersion"/>
				</content:ForVersion>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:TrickMode">
				<content:TrickMode>
					<xsl:value-of select="tns:Fields/tns:TrickMode"/>
				</content:TrickMode>
			</xsl:if>		
		</Trick>
	</xsl:template>

	<xsl:template match="tns:Fields/tns:CustomFields/tns:CustomField[../../../@type='TRICK']">
		<xsl:if test="empty(index-of(('ContentRef'),@name))">
			<xsl:call-template name="customField">
				<xsl:with-param name="app" select="$Trick/tns:Fields/tns:ProductInfo/tns:Name" />
				<xsl:with-param name="name" select="@name" />
				<xsl:with-param name="value" select="@value" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>