/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.ruleengine;

import com.tandbergtv.cms.rules.service.category.IRuleExecutionHandler;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleService;
import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorResponseImpl;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class RunLocalContentProcessingHandler {
    private static final String CONTENT_PROCESSING_SCHEDULED = "contentProcessingScheduled";
    private static final String TEMPLATES = "Templates";
    private static final String TITLE_ID = "TitleID";
    Logger logger = Logger.getLogger(RunLocalContentProcessingHandler.class);

    public IAdaptorResponse handleMessage(WorkflowMessage message) throws AdaptorException {
        String titleID = message.getValue(TITLE_ID);
        IMessage response = null;
        IRuleExecutionHandler reh = null;
        try {
            reh = (IRuleExecutionHandler)new InitialContext().lookup("cms/EventHandler/local");
            TrePackage trePackage = new TrePackage();
            trePackage.setName("PROCESSING");
            ServiceRegistry defaultServiceRegistry = ServiceRegistry.getDefault();
            ITitleService titleService = (ITitleService)defaultServiceRegistry.lookup(ITitleService.class);
            this.logger.debug((Object)("Obtained titleService=" + titleService));
            Title title = titleService.getTitleForUpdate(new Long(titleID));
            this.logger.debug((Object)("titleId=" + title.getId()));
            RuleResults ruleResults = reh.runRuler(title, TreEvent.TARGETED, trePackage);
            List templateNames = ruleResults.getTemplateNames();
            boolean contentProcessingScheduled = ruleResults.ranContentProcessingTemplate();
            response = this.prepareAckMessage(message, templateNames, contentProcessingScheduled);
        }
        catch (NamingException e) {
            this.logger.error((Object)"Unable to obtain IRuleExecutionHandler implementation from context", (Throwable)e);
            response = this.prepareNackMessage(message, e.getMessage());
        }
        catch (Exception ex) {
            this.logger.error((Object)"Unable to Run Local Content Processing Rule", (Throwable)ex);
            response = this.prepareNackMessage(message, ex.getMessage());
        }
        return new AdaptorResponseImpl(response);
    }

    private IMessage prepareAckMessage(WorkflowMessage message, List<String> templateNames, boolean contentProcessingScheduled) throws AdaptorException {
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID());
        response.setType(WorkflowMessage.MessageType.ack);
        response.setKey(message.getKey());
        String commaSeparatedListOfTemplateNames = "";
        if (templateNames != null && templateNames.size() > 0) {
            commaSeparatedListOfTemplateNames = templateNames.toString().substring(1, templateNames.toString().length() - 1);
        }
        response.putValue(TEMPLATES, commaSeparatedListOfTemplateNames);
        response.putValue(CONTENT_PROCESSING_SCHEDULED, new Boolean(contentProcessingScheduled).toString());
        try {
            return new WPCLConverter().convert(response);
        }
        catch (Exception ex) {
            throw new AdaptorException((Throwable)ex);
        }
    }

    private IMessage prepareNackMessage(WorkflowMessage message, String errorMessage) throws AdaptorException {
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID());
        response.setType(WorkflowMessage.MessageType.nack);
        response.setKey(message.getKey());
        response.getPayload().putValue("error-message", errorMessage);
        try {
            return new WPCLConverter().convert(response);
        }
        catch (Exception ex) {
            throw new AdaptorException((Throwable)ex);
        }
    }
}

