/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.ruleengine;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorResponseImpl;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class RunNormalizationRuleHandler {
    private static final String RULE_SET_ID_PARAMETER = "ruleSetId";
    private static final String CORRELATION_ID_PARAMETER = "correlationId";
    private IAdaptorConfiguration conf = null;
    private static final String REQUEST_QUEUE_NAME = "requestQueue";
    private static final String RESPONSE_QUEUE_NAME = "responseQueue";
    Logger logger = Logger.getLogger(RunNormalizationRuleHandler.class);

    public RunNormalizationRuleHandler(IAdaptorConfiguration arg0) {
        this.conf = arg0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAdaptorResponse handleMessage(WorkflowMessage message) throws AdaptorException {
        String ruleSetId = message.getValue(RULE_SET_ID_PARAMETER);
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        IMessage response = null;
        try {
            InitialContext context = new InitialContext();
            QueueConnectionFactory factory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            queueConnection = factory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(false, 1);
            this.logger.debug((Object)("Queue name read = " + this.conf.getParameterValue(REQUEST_QUEUE_NAME)));
            this.logger.debug((Object)("Queue name read = " + this.conf.getParameterValue(RESPONSE_QUEUE_NAME)));
            Queue queue = (Queue)context.lookup((String)this.conf.getParameterValue(REQUEST_QUEUE_NAME));
            QueueSender queueSender = queueSession.createSender(queue);
            Queue responseQueue = (Queue)context.lookup((String)this.conf.getParameterValue(RESPONSE_QUEUE_NAME));
            ObjectMessage queueMessage = queueSession.createObjectMessage();
            queueMessage.setStringProperty(RULE_SET_ID_PARAMETER, ruleSetId);
            queueMessage.setJMSReplyTo((Destination)responseQueue);
            queueSender.send(queue, (Message)queueMessage);
            response = this.prepareAckMessage(message, queueMessage.getJMSMessageID());
        }
        catch (Exception ex) {
            this.logger.error((Object)"Error sending message to queue", (Throwable)ex);
            response = this.prepareNackMessage(message, ex.getMessage());
        }
        finally {
            try {
                if (queueSession != null) {
                    queueSession.close();
                }
            }
            catch (Exception e) {}
        }
        return new AdaptorResponseImpl(response);
    }

    private IMessage prepareNackMessage(WorkflowMessage message, String errorMessage) throws AdaptorException {
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID());
        response.setType(WorkflowMessage.MessageType.nack);
        response.setKey(message.getKey());
        response.getPayload().putValue("error-message", errorMessage);
        try {
            return new WPCLConverter().convert(response);
        }
        catch (Exception ex) {
            throw new AdaptorException((Throwable)ex);
        }
    }

    private IMessage prepareAckMessage(WorkflowMessage message, String id) throws AdaptorException {
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID());
        response.setType(WorkflowMessage.MessageType.ack);
        response.setKey(message.getKey());
        response.putValue(CORRELATION_ID_PARAMETER, id);
        try {
            return new WPCLConverter().convert(response);
        }
        catch (Exception ex) {
            throw new AdaptorException((Throwable)ex);
        }
    }
}

