/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SMDispatcher;
import com.ericsson.cms.sites.core.ISiteManager;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class DistributeSiteTitleRequestMessageDispatcher
extends SMDispatcher {
    private Logger logger = Logger.getLogger(DistributeSiteTitleRequestMessageDispatcher.class);

    public DistributeSiteTitleRequestMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    public WorkflowMessage generateResponse(WorkflowMessage message) {
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{"TitleID"});
        Long titleId = Util.getLongValue((WorkflowMessage)message, (String)"TitleID");
        try {
            ISiteManager siteManager = (ISiteManager)new InitialContext().lookup("cms/SiteManager/local");
            this.logger.debug((Object)("Inside " + ((Object)((Object)this)).getClass().getSimpleName() + ", titleId=" + titleId));
            siteManager.distribute(titleId.longValue());
        }
        catch (Exception e) {
            String msg = "Failed to distribute the Site Title, error: " + e.getMessage();
            return this.generateNackMessage(message, msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        return response;
    }
}

